__author__ = 'hvishwanath'

import os
import shutil
import subprocess
import stat


def pip_install_local(source_cache, target_platform, target_dir, package_list=[], python_path="python3"):
    """
    pip install --find-links=file://$SDIST_CACHE_CAF --index-url=file:///dev/null --no-index --target=local/lib futures
    """
    # Create a virtual env first

    #venv_dir = os.path.join(os.path.expanduser("~"), 'bc3cgr')
    venv_dir = os.path.join(os.path.expanduser("~"), target_platform)
    if os.path.isdir(venv_dir):
        shutil.rmtree(venv_dir)

    subprocess.check_output(["virtualenv", venv_dir])

    cmdlist = ['pip', 'install']
    cmdlist.extend(["--find-links=file://%s" % k for k in source_cache])
    cmdlist.extend(['--index-url=file:///dev/null',
                    '--ignore-installed',
                    '--no-index',
                    '--target=%s' % target_dir
                    ])

    setup_script = ["#!/bin/bash", ". %s" % os.path.join(venv_dir, "bin/activate")]

    reqs = []
    for p in package_list:
        if p == '':
            continue
        reqs.append(p)

    with open("requirements.txt", "w") as freq:
        freq.write("\n".join(reqs))
    cmdlist.append("-r")
    cmdlist.append("requirements.txt")

    setup_script.append(" ".join(cmdlist))

    with open("setup_script.sh", "w") as fsetup:
        fsetup.write("\n".join(setup_script))
    os.chmod("setup_script.sh", stat.S_IRWXU|stat.S_IRGRP|stat.S_IXGRP|stat.S_IROTH|stat.S_IXOTH)

    try:
        script_content = ""
        with open("setup_script.sh", "r") as fsetup:
            script_content = fsetup.read()
        print("Running the script : \n%s" % script_content)
        subprocess.check_output("./setup_script.sh", shell=True)
        print("Removing temp files..")
        os.remove("setup_script.sh")
        os.remove("requirements.txt")
    except subprocess.CalledProcessError as ex:
        print("Error while installing packages..")
        print(str(ex))
        print(ex.output)
        raise


def install_packages_without_pip(source_cache, target_platform, target_dir, package_list=[], python_path="python3"):
    """
    Cisco build servers do not support pip and virtualenv. Try using distutils (setup.py) to install in a pip --target fashion.


    python setup.py install --root=/tmp/modules  --install-purelib --install-lib --install-platlib --install-scripts --install-data --install-headers

    """

    # Create a staging directory to copy and extract the source files from source_cache
    import tempfile
    staging_dir = tempfile.mkdtemp(suffix="cafbuild")
    print("Created staging directory for module installations at : %s" % staging_dir)

    setup_script = ["#!/bin/bash"]

    # Start adding commands to install each module
    for p in package_list:
        if p == '':
            continue

        # Remove trailing comments
        l = p.split("#")[0].strip()
        if not l:
            continue

        module_tarball_name = "%s.tar.gz" % l.replace("==", "-") # Results in something like CherryPy-3.2.5.tar.gz
        module_name = l.split("==")[0]

        module_tarball_source = None
        for d in source_cache:
            if os.path.isfile(os.path.join(d, module_tarball_name)):
                module_tarball_source = os.path.join(d, module_tarball_name)
                break

        if module_tarball_source == None:
            raise ValueError("Cannot find source location for %s in %s" % (module_tarball_name, str(source_cache)))

        # Craft commands to untar and run setup.py pointint to target dir.
        print_cmd = "echo Installing %s to %s" % (module_tarball_source, target_dir)
        untar_cmd = "tar -zxvf %s -C %s" % (module_tarball_source, staging_dir)
        cd_cmd = "cd %s/%s" % (staging_dir, module_tarball_name.replace(".tar.gz",""))
        if "PyYAML" in module_tarball_name:
            # For PyYAML force compiling without libyaml support
            install_cmd = "%s setup.py --without-libyaml install --root=%s  --install-purelib= --install-lib= --install-platlib= --install-scripts= --install-data= --install-headers= --install-scripts=bin" % (python_path, target_dir)
        elif module_name in ["jaraco_functools", "more-itertools"]: 
            install_cmd = "%s -m pip install --root=%s --no-deps --prefix '..' . ; mv %s/python3.10/site-packages/* %s;" % (python_path, target_dir, target_dir, target_dir)
        else:
            install_cmd = "%s setup.py install --root=%s  --install-purelib= --install-lib= --install-platlib= --install-scripts= --install-data= --install-headers= --install-scripts=bin" % (python_path, target_dir)

        setup_script.append(print_cmd)
        setup_script.append(untar_cmd)
        setup_script.append(cd_cmd)
        setup_script.append(install_cmd)


    with open("setup_script.sh", "w") as fsetup:
        fsetup.write("\n".join(setup_script))
        
    os.chmod("setup_script.sh", stat.S_IRWXU|stat.S_IRGRP|stat.S_IXGRP|stat.S_IROTH|stat.S_IXOTH)

    try:
        script_content = ""
        with open("setup_script.sh", "r") as fsetup:
            script_content = fsetup.read()
        print("Running the script : \n%s" % script_content)
        subprocess.check_output("./setup_script.sh", shell=True)
        print("Removing temp files..")
        os.remove("setup_script.sh")
    except subprocess.CalledProcessError as ex:
        print("Error while installing packages..")
        print(str(ex))
        print(ex.output)
        raise
    finally:
        shutil.rmtree(staging_dir, ignore_errors=True)

def get_missing_pystdlibs(source_files, target_dir):
    for f in source_files:
        if os.path.isfile(f):
            shutil.copy2(f, target_dir)
        elif os.path.isdir(f):
            shutil.copytree(f, os.path.join(target_dir, os.path.basename(f)))

def remove_src_files(target_dir):
    # First compile all python files in the target dir
    import compileall
    import fnmatch
    print("Python compiling all files in dir : %s" % target_dir)
    compileall.compile_dir(target_dir, force=True, legacy=True)

    # Remove all *.py files from the directory
    matches = []
    for root, dirnames, filenames in os.walk(target_dir):
        for filename in fnmatch.filter(filenames, '*.py'):
            matches.append(os.path.join(root, filename))

    for m in matches:
        print("removing %s" % m)
        os.remove(m)

def setup_local_manager(xwt_home, rootdir=None):
    """
    Package local manager and provision with xwt toolkit.
    Uses the make file that is already present in core/lm
    :param xwt_home:
    :return: none
    """
    print("Packaging Local Manager UI components..")
    print("Will search for XWT bundle at : %s" % xwt_home)
    print("Calling local manager makefile core/lm/scripts/Makefile")
    if rootdir is None:
        rootdir = os.getcwd()

    workdir = os.path.join(rootdir, "core/lm/scripts")
    try:
        p = subprocess.check_output(args="make",
                                    env={"IOX_XWT_HOME": xwt_home,
                                         "USER": os.environ.get('USER'),
                                         "PATH": os.environ.get('PATH')
                                    },
                                    cwd=workdir
        )
        print("LM components provisioned successfully..")

        # Once the makefile is successful, it creates a build at
        # obj/core/lm/build/release/static
        # copy it to the actual source tree
        shutil.rmtree("core/lm/static")
        shutil.copytree("obj/core/lm/build/release/static", "core/lm/static")
        print("Copied LM build into working tree successfully..")

        # Remove the obj folder
        print("Removing temporary obj directory")
        shutil.rmtree("obj")

    except subprocess.CalledProcessError as e:
        print("!!!ERROR!!! LM Makefile did not complete successfully. RC: %s" % str(e.returncode))
        print("OUTPUT: %s" % str(e.output))

    return

