#!/bin/sh 
# config_reset_setup.sh script is used in platforms which support physical Config reset operation like
# in IC3000. This script will be called from platform's config_reset handler to execute any business logic 
# that will be used to notify CAF which will then notify apps to do config reset. 

ROOTDIR="/sw/opt/cisco/"
CAFDIR="$ROOTDIR/caf"
CAFWORKDIR="$CAFDIR/work"
SENTINEL="configreset.sentinel"
if [ ! -d $ROOTDIR ]; then
    logger -p local0.error -t config_reset_iox "Root dir $ROOTDIR doesn't exist to create IOx config reset sentinel"
    exit 1 
fi 

if [ ! -d $CAFWORKDIR ]; then 
    mkdir -p $CAFWORKDIR
fi

touch $CAFWORKDIR/$SENTINEL
logger -p local0.info -t config_reset_iox "Successfully created IOx config reset sentinel file"

exit 0
