__author__ = 'madawood'

import os
import yaml
import sys
CONFIG_DIR_PATH = "../config/"
SECURITY_CONFIG_FILE = os.path.join(CONFIG_DIR_PATH, "security_config.yaml")

def enable_sec():
    sec_config = {}
    with open(SECURITY_CONFIG_FILE, "r") as f:
        sec_config = yaml.load(f)
        if not sec_config.get("enabled"):
            print("Security os not enabled, So enabling it!")
            sec_config["enabled"] = True
            sec_config["lsm_model"] = "smack"
        else:
            return
    with open(SECURITY_CONFIG_FILE, "w") as f:
        yaml.dump(sec_config, f)

if "__main__" == __name__:
    args = sys.argv
    print("Arguments passed to python script:",args[1:])
    for arg in args[1:]:
        if arg.strip() == "enable_sec":
            enable_sec()


