#! /usr/bin/python
 
import docker
import sys
import json
 
if len(sys.argv) < 2:
    print('Usage: argv[0] parameter ...')
    exit(1)
 
try:
    client=docker.from_env()
    arg1 = sys.argv[1]
    if arg1 == 'version':
        # return docker version
        ver = client.version()
        print(ver['Version'])

    elif arg1 == 'info':
        # return docker info
        print(client.info())
 
    elif arg1 == 'ps':
        apiclient=docker.APIClient()
        print(json.dumps(apiclient.containers(all=True),indent=2))
 
    elif arg1 == 'images':
        apiclient=docker.APIClient()
        print(json.dumps(apiclient.images(all=True),indent=2))
 
    elif arg1 == 'processID':
        # return the process id of the given docker container
        apiclient=docker.APIClient()
        if len(sys.argv) < 3:
            print('container id is missing')
            exit(1)
        ctnInfo=apiclient.inspect_container(sys.argv[2])
        print(ctnInfo['State']['Pid'])
 
    elif arg1 == 'containerID':
        # return docker container ID
        if len(sys.argv) < 3:
            print('appid is missing')
            exit(1)
        appid = sys.argv[2]
        container = client.containers.get(appid)
        print(container.id)
 
    elif arg1 == 'containerIP':
        # return IP address of container interfaces
        if len(sys.argv) < 3:
            print('appid is missing')
            exit(1)
        appid = sys.argv[2]
        container = client.containers.get(appid)
        print(container.exec_run("ip address"))

    elif arg1 == 'cmd':
        # Execute the docker container commands
        if len(sys.argv) < 4:
            print('appid is missing')
            exit(1)
        appid = sys.argv[3]
        container = client.containers.get(appid)
        rc, output = container.exec_run(sys.argv[2])
        print(output)
        if rc != 0:
            exit(1)

    elif arg1 == 'inspect':
        # return detailed container information
        if len(sys.argv) < 3:
            print('appid is missing')
            exit(1)
        apiclient=docker.APIClient()
        ctnInfo=apiclient.inspect_container(sys.argv[2])
        print(json.dumps(ctnInfo, indent=4))

    elif arg1 == 'removeall':
        # return detailed container information
        apiclient=docker.APIClient()
        ctn_list=apiclient.containers(quiet=True, all=True)
        for container in ctn_list:
            apiclient.stop(container["Id"])
            apiclient.remove_container(container["Id"], force=True)

    elif arg1 == 'logs':
        # return container logs
        if len(sys.argv) < 3:
            print('appid is missing')
            exit(1)
        apiclient=docker.APIClient()
        print((apiclient.logs(sys.argv[2], timestamps=True)).decode("utf-8"))

    else:
        # unsupported API option
        print('unsupported API option', str(sys.argv))
        exit(1)
 
except Exception as e:
    print("Failed to complete docker client api %s: %s" % (arg1, str(e)))
    exit(1)
