#!/usr/bin/python -tt
'''
Created on Apr 23, 2012

@author: rnethi
'''

import signal
import traceback
import sys

def startService(*args, **kwargs):
    '''
    Start connector hosting service
    '''

    from appfw.runtime.hostingmgmt import HostingManager
    hosting_manager = HostingManager(*args)
    hosting_manager.start_infra()
    
def stopService():
    '''
    Stop connector hosting service
    '''
    from appfw.runtime.hostingmgmt import HostingManager
    hosting_manager = HostingManager.get_instance()
    if not hosting_manager is None:
        hosting_manager.stop_infra()


def _sleep_handler(signum, frame):
    print("SIGINT Received. Stopping CAF")
    raise KeyboardInterrupt

def _stop_handler(signum, frame):
    print("SIGTERM Received. Stopping CAF")
    raise KeyboardInterrupt


signal.signal(signal.SIGTERM, _stop_handler)
signal.signal(signal.SIGINT, _sleep_handler)


if __name__ == "__main__":
    import sys
    import os
    import time

    scripts_dir = os.path.dirname(os.path.abspath(sys.argv[0]))
    caf_dir = os.path.dirname(scripts_dir)
    src_dir = os.path.join(caf_dir, "src")

    sys.path.insert(0, src_dir)
    sys.path.append(os.path.join(caf_dir, "../local/lib"))
    sys.path.append(os.path.join(caf_dir, "../local/pystdlib"))

    if len(sys.argv) > 1:
        system_config = sys.argv[1]
    if len(sys.argv) > 2:
        log_config = sys.argv[2]
    else:
        log_config = None

    # Start CAF runtime service
    try:
        startService(system_config, log_config)

        # Block till we receive a SIGTERM, SIGINT or KeyboardInterrupt
        while True:
            try:
                time.sleep(5)
            except KeyboardInterrupt:
                stopService()
                break
    except Exception as ex:
        print("Got Exception: Stopping CAF")
        traceback.print_exc(file=sys.stdout)
        stopService()
