# Copyright (c) 2014 by Cisco Systems, Inc.
# All rights reserved
#!/bin/sh

MAX_WAIT=60

LOGG_INFO="logger -t IOX-CAF -p user.info"
CAF_STOP_LOG="/tmp/iox/iox-caf-stop.log"

echo " Stopping CAF " > $CAF_STOP_LOG
if [ ! -f /var/run/caf.pid ] ; then
    $LOGG_INFO "Cannot find CAF's pid file /var/run/caf.pid"
    echo " Cannot find the CAF pid file. Exiting " >> $CAF_STOP_LOG
    exit 0
fi


active=`systemctl is-active caf-healthcheck.service`
if [ "$active" == "active" ]; then
    systemctl stop caf-healthcheck.service
fi

# Send SIGINT to CAF process
pid=`cat /var/run/caf.pid`
$LOGG_INFO "Stopping CAF (pid:$pid)."
/bin/kill -SIGINT $pid > /dev/null 2>&1

waited=0

# Wait for CAF to stop; Send SIGKILL after MAX_WAIT time.
ls /proc/$pid > /dev/null 2>&1
while [ "$?" -eq 0 ]
do
    if [ "$waited" -gt $MAX_WAIT ]
    then
        $LOG_INFO "Waited $MAX_WAIT seconds for CAF (pid:$pid) to stop; killing the process now."
        echo "Waited $MAX_WAIT seconds for CAF (pid:$pid) to stop; killing the process now." >> $CAF_STOP_LOG
        /bin/kill -9 $pid
        rm -rf /var/run/caf.pid
        exit 0
    fi
    sleep 1
    echo " CAF Process is still running. Sleeping for 1 sec" >> $CAF_STOP_LOG
    waited=$((waited+1))
    ls /proc/$pid > /dev/null 2>&1
done

echo " Stopped CAF $pid " >> $CAF_STOP_LOG
# CAF stopped on it's own, great!
$LOGG_INFO "CAF stopped successfully"
exit 0
