import logging
import os
import time
import falcon
import threading
from datetime import datetime
log = logging.getLogger("runtime.api")

NO_OF_REQS_PER_SEC = 3
COUNT = "count"
TIMESTAMP = "timestamp"

class RateLimiterMiddleware(object):

    def __init__(self):
        self.history = {}
        self.os_child_req = 0
    def process_request(self, req, resp, **kwargs):
        if req.path.endswith(("ioxv/datapoints", "ioxv/metadata", "iox/api/v2/hosting/datastore")):
            thread_id = threading.currentThread().name
            metadata = {}
            if thread_id in self.history:
                metadata = self.history[thread_id]
            else:
                metadata[TIMESTAMP] = int(time.time())
                metadata[COUNT] = 1
                self.history[thread_id] = metadata
                return

            if metadata[TIMESTAMP] == int(time.time()):
                if metadata[COUNT] < NO_OF_REQS_PER_SEC:
                    metadata[COUNT] = metadata[COUNT] + 1
                else:
                    log.debug("Dropping req for path %s metadata %s" %(req.path, metadata))
                    raise falcon.HTTPTooManyRequests('Too many requests',
                                                        '%s per sec'%NO_OF_REQS_PER_SEC)
            else:
                #reset the counters
                metadata[TIMESTAMP] = int(time.time())
                metadata[COUNT] = 1
        if req.path.find('/child') != -1:
            thread_id = threading.currentThread().name
            log.debug("Child Request: %s Thread name: %s" % (req.path, thread_id))
            if self.os_child_req >= 4 :
                log.error("Dropping req for path %s" %req.path)
                raise falcon.HTTPTooManyRequests('Too many child pending requests:%s' % self.os_child_req)
            else:
                self.os_child_req = self.os_child_req + 1
        
    def process_response(self, request, response, resource, req_succeeded):
        # Reading and flusing the request stream, in order to prevent data to load in memory
        if request.path.find('/child') != -1:
            thread_id = threading.currentThread().name
            log.debug("Completed Child Request: %s Thread name: %s" % (request.path, thread_id))
            self.os_child_req = self.os_child_req - 1
