'''
Created on Jul 14, 2014

@author: utandon

Copyright (c) 2012-2013 by Cisco Systems, Inc.
All rights reserved.
'''
import json
import falcon

from  .processinfo import ProcessInfo
from .apiservice import  ResourceRoute, APIService
from .common import AuthenticatedResource, make_response

@ResourceRoute("/service-bundles/metrics", endpoint="service_bundles_metrics")
@ResourceRoute("/apps/metrics", endpoint="apps_metrics")
class AppsMetricsResourceHandler(AuthenticatedResource):

    def on_get(self, request, response):
        if request.path.find("/service-bundles") != -1:
            appsMetrics = APIService.instance.app_manager.get_app_metrics(is_service=True)
        else:
            appsMetrics = APIService.instance.app_manager.get_app_metrics()
        datastr = json.dumps(appsMetrics)
        response = make_response(response, datastr, falcon.HTTP_200)
        response.set_header('Content-Type', "application/json")
        response.set_header('Cache-Control', "no-cache")
