__author__="madawood"

from .jsonencoder import JSONEncoder
import logging

from .apiservice import APIService

log = logging.getLogger("runtime")
jsonencoder = JSONEncoder()


class CAFServiceManagement(object):
    hm = APIService.instance.hosting_manager

    def __init__(self):
        pass

    @classmethod
    def start_service(cls, service_name):
        serv = cls.get_service(service_name)
        if serv:
            if not serv.is_running:
                cls.set_config(service_name, {"enabled": True})
                if not serv.is_running:
                    log.error("service %s is not started!"%service_name)
                    raise Exception("service %s is not started!"%service_name)
            else:
                log.debug("Service %s is already running, so nothing to do!"%service_name)

    @classmethod
    def stop_service(cls, service_name):
        serv = cls.get_service(service_name)
        if serv:
            if serv.is_running:
                cls.set_config(service_name, {"enabled": False})
                if serv.is_running:
                    log.error("Service %s is not stopped!"%service_name)
                    raise Exception("Service %s is not stopped!"%service_name)
            else:
                log.debug("Service %s is already stopped, so nothing to do!"%service_name)

    @classmethod
    def get_service(cls, service_name):
        return cls.hm.get_service(service_name)

    @classmethod
    def set_config(cls, service_name, config):
        serv = cls.get_service(service_name)
        if serv:
            try:
                serv.set_config(config)
            except NotImplementedError:
                log.exception("Service %s doesn't support changes!"%service_name)
                raise NotImplementedError("Service %s doesn't support changes!"%service_name)

    @classmethod
    def get_config(cls, service_name):
        serv = cls.get_service(service_name)
        if serv:
            try:
                return serv.get_config()
            except NotImplementedError:
                log.exception("Service %s doesn't support get on config!"%service_name)
                raise NotImplementedError("Service %s doesn't support get on config!"%service_name)

    @classmethod
    def list_all_services(cls):
        return cls.hm.list_services()
