__author__ = 'rgowrimo'
import json
import falcon
from .common import make_response, make_error_response
from .apiservice import ResourceRoute, APIService
from appfw.utils.utils import Utils
import shutil
import os
import logging
from .common import AuthenticatedResource, make_response
from ..utils.cafevent import CAFEvent

log = logging.getLogger("runtime.api.resources")

@ResourceRoute("/reload", endpoint="reload")
class ReloadResource(AuthenticatedResource):

    def on_post(self, request, response):
        try:
            hm = APIService.instance.hosting_manager
            appRestart = request.get_param("app_restart")
            if appRestart == "yes":
                hm.reload(app_restart=True)
            else:
                #By default , do not restart the App i.e do not shutdown the apps
                hm.reload(app_restart=False)
            log.info("Reload is initiated successfully")
        except Exception as ex:
            log.exception("Error while calling reset on hosting manager.: %s" % str(ex))
            make_error_response(response, "Reload failed", "Reload failed", falcon.HTTP_500)
            return
        response = make_response(response, "Reload initiated.", falcon.HTTP_200)
        ns = APIService.instance.hosting_manager.get_service("notification-service")
        event_type = CAFEvent.TYPE_CAF_RELOAD
        event_message = "CAF Reload initiated"

        if ns and event_type:
            log.debug("Posting '%s' event" % event_type)
            ns.post_event(CAFEvent(None,
                                   event_type,
                                   CAFEvent.SOURCE_RESTAPI, event_message=event_message))
        return
