__author__ = 'madawood'
import json
import falcon
from .common import make_response, make_error_response
from .apiservice import ResourceRoute, APIService
from appfw.utils.utils import Utils
import shutil
import os
import logging
from .common import AuthenticatedResource, make_response

log = logging.getLogger("runtime.api.resources")

@ResourceRoute("/reset", endpoint="reset")
class ResetResource(AuthenticatedResource):

    def on_post(self, request, response):
        try:
            hm = APIService.instance.hosting_manager
            hm.reset()
            log.info("Reset is initiated successfully")
        except Exception as ex:
            log.exception("Error while calling reset on hosting manager.: %s" % str(ex))
        response = make_response(response, "Reset flag set. Reset will be done on next restart.", falcon.HTTP_200)
        return
