'''
Created on Apr 02, 2015

@author: utandon

Copyright (c) 2015-2016 by Cisco Systems, Inc.
All rights reserved.
'''
import os
import logging
import shutil
import subprocess
import logging
from appfw.utils.utils import Utils
from appfw.utils.commandwrappers import *
log = logging.getLogger("cartridge")

class Ext2_Handler(object):    
    __singleton = None # the one, true Singleton

    def __new__(cls, *args, **kwargs):
        # Check to see if a __singleton exists already for this class
        # Compare class types instead of just looking for None so
        # that subclasses will create their own __singleton objects
        if cls != type(cls.__singleton):
            cls.__singleton = super(Ext2_Handler, cls).__new__(cls)
        return cls.__singleton

    @classmethod
    def getInstance(cls, *args):
        '''
        Returns a singleton instance of the class
        '''
        if not cls.__singleton:
            cls.__singleton = Ext2_Handler(*args)
        return cls.__singleton

    def get_payload(self, payload, target_dir): 
        """ 
        Mounts the payload to target_dir. 
        payload is expected to be in ext2 format
        """

        if not Utils.ismount_exists(target_dir) :
            out, rc = mountext2("-o", "ro", payload, target_dir)
            if rc != 0:
                log.error("Error in mounting directory: %s", str(out))
                raise Exception("Error in mounting directory: %s", str(out))


    def remove(self, path):
        """
        path is treated as the moutn point which will be unmounted
        """
        subprocess.check_output(["umount", "-l" , path], shell=False)
