'''
Created on Apr 02, 2015

@author: utandon

Copyright (c) 2015-2016 by Cisco Systems, Inc.
All rights reserved.
'''
import logging
log = logging.getLogger("cartridge")

class FormatHandler(object):
    """
    RFS Composer to get aufs/non aufs composer 
    """
    
    @classmethod
    def get_format_handler(cls, format="ext2"):
        """
        From the  returns the specific format handler class
        """
        if format == "ext2":
            from .ext2_handler import Ext2_Handler
            return Ext2_Handler.getInstance()
        else:
            log.error("cartridge format of type %s not supported" % format)
            raise ValueError("cartridge format of type %s not supported" % format)

