var socket = null;
var term = null;
var inactivityTimeout = 2 * 1000 * 60; // 2 mins. This value is in milli seconds.
var token, appType;
var appData;
var appType;
var appState;
var status;
var port, hostname, protocol;
var appName;
var isReloadIframe;
var reloadShellValue;
var logoffTimer;

window.addEventListener("load", (event) => {
  var isReload =
    new URLSearchParams(window.location.search).get("reload") || undefined;

  consoleTerminalStateChangeHandler();
  if (!isReload) {
    isReloadIframe = false;
    reloadShellValue = "";
  }

  if (isReload) {
    var selectShell =
      new URLSearchParams(window.location.search).get("shell") || undefined;
    var select_elem = document.getElementById("shell-select");
    select_elem.value = selectShell;
    isReloadIframe = true;
    reloadShellValue = selectShell;
    startFunction();
  }
});

window.addEventListener(
  "message",
  function (event) {
    var data;
    var container = document.getElementById("terminalContainer");
    var disconnectMsg = document.getElementById("terminalDisconnectMessage");

    if (event.data !== "") {
      data = JSON.parse(event.data || {});
    }

    if (data) {
      var message = data.message;
      var appState = data.appState;
      disableButtons(true,appState);
      switch (message) {
        case "setToken":
          if (data && data.appName) {
            setShellOptions(data);
          }
          break;

        case "disableConnectButton":
          var start = document.getElementById("terminalStartButton");
          start.classList.add("disabled");
          start.disabled = true;
          break;

        default:
          window.onbeforeunload();
          break;
      }
    }
    if (container) {
      container.style.display = "";
    }
    if (disconnectMsg) {
      disconnectMsg.style.display = "none";
    }
  },
  false
);

window.onbeforeunload = function () {
  disconnectSocket();
};

function sendStateToParent() {
  var url = getParentUrl();
  var data = {
    appName: appName,
    message: "resetReloadOptions",
  };
  window.parent.postMessage(JSON.stringify(data), url);
}

function consoleTerminalButtonHandler(currentState) {
  switch (currentState) {
    case "disconnect":
      disconnectSocket();
      sendStateToParent();
      break;

    case "reload":
      reloadIframe();
      break;

    case "start":
      startFunction();
      sendStateToParent();
      break;
  }
}

function consoleTerminalStateChangeHandler(currentValidState) {
  // Current valid state = empty
  var disconnect, start, close;
  disconnect = document.getElementById("terminalDisconnectButton");
  close = document.getElementById("terminalReloadButton");
  start = document.getElementById("terminalStartButton");
  if (currentValidState === undefined || currentValidState === "") {
    start.style.display = "";
    disconnect.style.display = "none";
    close.style.display = "none";
  } else if (currentValidState === "disconnect") {
    close.style.display = "";
    disconnect.style.display = "none";
    start.style.display = "none";
  } else if (currentValidState === "start") {
    disconnect.style.display = "";
    close.style.display = "none";
    start.style.display = "none";
  }
}

function disableButtons(appType, appState) {
  var disconnect, start, close;
  disconnect = document.getElementById("terminalDisconnectButton");
  close = document.getElementById("terminalReloadButton");
  start = document.getElementById("terminalStartButton");
  if (!appType || (appState && appState.toLowerCase() !== "running")) {
    start.classList.add("disabled");
    disconnect.classList.add("disabled");
    close.classList.add("disabled");
    start.disabled = true;
    disconnect.disabled = true;
    close.disabled = true;
  } else if (appState && appState.toLowerCase() === "running") {
    start.classList.remove("disabled");
    disconnect.classList.remove("disabled");
    close.classList.remove("disabled");
    start.disabled = false;
    disconnect.disabled = false;
    close.disabled = false;
  }
}

function setShellOptions(data) {
  let select_elem = document.getElementById("shell-select");
  let shellOptions =
    (data &&
      data["exec_console_data"].enabled &&
      data["exec_console_data"]["container_cmds_supported"]) ||
    undefined;
  appData = data;
  appType = data && data.appType;
  appState = data && data.appState;
  appName = data && data.appName;
  hostname = data && data.hostname;
  port = data && data.port;
  protocol = data && data.protocol;
  isReloadIframe =
    (data && data.isReloadIframe) ||
    new URLSearchParams(window.location.search).get("reload");
  reloadShellValue =
    (data && data.reloadShellValue) ||
    new URLSearchParams(window.location.search).get("shell");

  select_elem.innerHTML = "";
  select_elem.removeAttribute("disabled");

  if (appType === "vm") {
    if (
      data &&
      data["exec_console_data"] &&
      data["exec_console_data"].vm_attach_console
    ) {
      shellOptions = ["attach console"];
    } else {
      let containerDiv = document.getElementById("terminalContainer");
      containerDiv.textContent =
        "VM app console is not supported on the platform";
    }
  }

  if (data && data["exec_console_data"] && data["exec_console_data"].enabled) {
    if (shellOptions) {
      shellOptions.forEach((element, index) => {
        let option_elem = document.createElement("option");
        option_elem.value = element;
        option_elem.textContent = element;
        select_elem.appendChild(option_elem);
      });
    }
  } else {
    select_elem.setAttribute("disabled", true);
  }
  disableButtons(appType);
  if (isReloadIframe) {
    select_elem.value = reloadShellValue;
  }
}

function emitDisconnectEvent() {
  socket.emit("disconnect", { reason: "Logged off due to inactivity" });
}

function disconnectSocket() {
  var status = document.getElementById("status");
  status.style.display = "";
  if (socket != null) {
    socket.disconnect();
    socket && socket.removeAllListeners();
    status.innerHTML =
      ' <span style="background-color: #ff8383;"> Disconnected</span>';
  }
  if (socket && !socket.disconnected) {
    disconnectSocket();
  }
}

function startFunction() {
  consoleTerminalStateChangeHandler("start");
  token = new URLSearchParams(window.location.search).get("X-Token-Id") || undefined;
  window.socket = window.socket || io.connect("/pty", { query: "X-Token-Id=" + token, reconnection: false });
  var status = document.getElementById("status");
  var statusLabel = document.getElementsByClassName("statusLabel");
  if (statusLabel && statusLabel[0]) {
    statusLabel[0].style.display = "";
  }
  //socket = io.connect('/pty', {secure: true});
  //  if appData is undefined it means, start was triggered by reload. hence fetch AppName from URL
  var appname = appData && appData.appName;
  var apptype = appData && appData.appType;
  var vmAttachConsole =
    appData &&
    appData["exec_console_data"] &&
    appData["exec_console_data"]["vm_attach_console"];
  var select = document.getElementById("shell-select");
  var selectValue = select.value;
  if (isReloadIframe) {
    apptype =
      new URLSearchParams(window.location.search).get("appType") || undefined;
    appname =
      new URLSearchParams(window.location.search).get("appName") || undefined;
    vmAttachConsole =
      new URLSearchParams(window.location.search).get("vmAttachConsole") ||
      false;
    selectValue = new URLSearchParams(window.location.search).get("shell");
    select.value = selectValue;
  }

  var cmd = document.getElementById("shell-select").value;
  var val = { appname: appname, cmd: cmd };
  var emitObj = {
    "X-App-Id": appname,
  };

  if (apptype.toLowerCase() === "vm") {
    emitObj["X-App-Attach-Console"] = vmAttachConsole;
  } else if (apptype.toLowerCase() === "docker") {
    emitObj["X-App-Exec-Interactive"] = true;
    emitObj["X-App-Exec-Command"] = selectValue || "/bin/sh";
  }

  socket.emit("start", emitObj);
  Terminal.applyAddon(fit);
  Terminal.applyAddon(webLinks);
  Terminal.applyAddon(search);
  Terminal.applyAddon(attach);
  const term = new Terminal({
    cursorBlink: true,
    macOptionIsMeta: true,
    scrollback: true,
    screenKeys: true,
  });
  term.open(document.getElementById("terminal"));
  term.fit();
  term.resize(75, 34);
  term.setOption("scrollback", 1000000);
  term.fit();

  status.innerHTML =
    ' <span style="background-color: lightgreen;"> Connected</span>';
  status.style.display = "";
  term.on("key", (key, ev) => {
    clearTimeout(logoffTimer);
    socket.emit("pty-input", { input: key });
    logoffTimer = setTimeout(emitDisconnectEvent, inactivityTimeout);
  });
  socket.on("pty-output", function (data) {
    term.write(data.output);
  });
  term.on("paste", function (data) {
    socket.emit("pty-input", { input: data });
  });
  socket.on("disconnect", function (data) {
    consoleTerminalStateChangeHandler("disconnect");
    var status = document.getElementById("status");
    var startButton = document.getElementById("terminalStartButton");
    disconnectSocket();
    startButton.setAttribute("disabled", true);
    status.style.display = "";
  });

  socket.on("end", function () {
    socket.disconnect(0);
  });

  socket.on("error", function (error) {
    consoleTerminalStateChangeHandler("disconnect");
    disconnectSocket();
  });

  socket.on("connect_error", function (error) {
    consoleTerminalStateChangeHandler("disconnect");
    var status = document.getElementById("status");
    status.style.display = "";
    disconnectSocket();
  });

  logoffTimer = setTimeout(emitDisconnectEvent, inactivityTimeout);
}

function getParentUrl() {
  return protocol + "//" + hostname + ":" + port;
}

function convertObjectToQueryString(obj) {
  return new URLSearchParams(obj).toString();
}

function postMessageToParent(data) {
  var url = getParentUrl();
  window.parent.postMessage(JSON.stringify(data), url);
}

function reloadIframe() {
  var select = document.getElementById("shell-select");
  disconnectSocket();
  var url = getParentUrl();
  var vmAttachConsole =
    (appData &&
      appData["exec_console_data"] &&
      appData["exec_console_data"]["vm_attach_console"]) ||
    false;
  var data = {
    appName: appName,
    message: "reloadIframeButtonHandler",
    shell: (select && select.value) || "",
  };
  var obj = {
    "X-Token-Id": token,
    reload: true,
    appType: appType,
    appName: appName,
    vmAttachConsole: vmAttachConsole,
    shell: select.value,
  };
  var queryString = convertObjectToQueryString(obj);
  window.location.href = window.location.origin + "?" + queryString;
}

function fitToscreen() {
  if (term != null) {
    term.fit();
    socket.emit("resize", { cols: term.cols, rows: term.rows });
  }
}

function debounce(func, wait_ms) {
  let timeout;
  return function (...args) {
    const context = this;
    clearTimeout(timeout);
    timeout = setTimeout(() => func.apply(context, args), wait_ms);
  };
}

const wait_ms = 50;
window.onresize = debounce(fitToscreen, wait_ms);
