'''
Created on Sep 29, 2012

@author: rnethi

Copyright (c) 2012-2013 by cisco Systems, Inc.
All rights reserved.
'''
import os
import logging

from .process   import ProcessContainerManager
from .process   import ProcessContainer
from c3svc.launcher import runner
 
log = logging.getLogger("runtime.hosting")

class InProcessContainer(ProcessContainer):
    """
   Container implementation that hosts the connectors in the same process as runtime.
   This container implementation works only for python based connectors as the runtime is python
    """
    def __init__(self, containerId, containerDir, processContainerManager):
        super(InProcessContainer, self).__init__(containerId, containerDir, processContainerManager)
        self._inProcConnectorEnv = None

    def start(self):
        """
        Starts a container
        """
        
        #This container has some internal knowledge about the connector file system organization. It is 
        #Ok for now because this container works only python connectors
        from ..runtime import runtime
        config = runtime.getRuntime().getConfig()
        c_dir = config.get("app-settings", "appDirName")
        connectorHome = os.path.join(self._containerDir, c_dir)
        connectorLogsDirName = config.get("app-settings", "appLogsDir")
        connectorAppDir =  "app"
        connectorModulesDir = "modules"
       
        log.debug("Starting in process container")
        self._inProcConnectorEnv = runner.run_connector_inprocess(self.getId(), connectorHome, connectorAppDir, connectorLogsDirName, connectorModulesDir) 
         
        return
    
    def stop(self, graceful=True):
        """
        Stops a container
        """
        log.debug("Stopping in process container")
        if self._inProcConnectorEnv is not None:
            self._inProcConnectorEnv.stop() 
        self._inProcConnectorEnv = None
        
        return
    
    def isRunning(self):
        """
        Tests if the connector is running or not
        """
        return self._inProcConnectorEnv is not None
    
    def runCommand(self, cmd):
        """
        Runs a command inside a container
        """
        pass

    def getProcessInfo(self):
        """
        Gets process information from inside a container
        """
        pass

    def getLogsList(self):
        """
        Gets list of logs from inside a container
        """
        return ''

    def getLogContents(self, fileName):
        """
        Gets logs contents for a given file from inside a container
        """
        return ''
    
class InProcessContainerManager(ProcessContainerManager):
    '''
    Container Manager implementation that hosts connectors in the same process as the runtime. 
    As a result,  this implementation really cannot provide isolation or resource constraints
    
    '''

    def inprocess(self):
        """    
        Indicates if the containers are managed in-process
        """
        return True

    def supportsRuntime(self, runtime):
        """
        Indicates if this container supports hosting the specified runtime.
        """
        
        #we support only python runtime as we run connectors in-process 
        return runtime.startswith("python")
    
    def _createContainerInstance(self, containerId, containerPath):
        """
        creates an instance of container
        """
        return InProcessContainer(containerId, containerPath, self)
            
