import falcon
import urllib.parse
from falcon import Response
import collections
import collections.abc

import logging
def extract_form_urlencoded(req):
    if "application/x-www-form-urlencoded" == req.get_header("content-type"):
        if hasattr(req.stream, 'seek'):
            # When consuming body for urlencoded form parsing, Falcon does not
            # reset it.
            # See https://github.com/falconry/falcon/pull/649.
            req.stream.seek(0)
        req_body = req.stream.read().decode()
        logging.debug("Request body: %s" % req_body)
        return urllib.parse.parse_qs(req_body)
    else:
        return {}

def extract_params(req):
    if hasattr(req.stream, 'seek'):
        # When consuming body for urlencoded form parsing, Falcon does not
        # reset it.
        # See https://github.com/falconry/falcon/pull/649.
        req.stream.seek(0)

    req_body = None
    if "application/x-www-form-urlencoded" == req.get_header("content-type"):
        req_body = req.stream.read().decode()
    elif "POST" == req.method or "PUT" == req.method:
        req_body = req.stream.read().decode()
    return req.uri, req.method, req_body, req.headers


def patch_response(resp, headers, body, status):
    if body:
        resp.body = body
    for k, v in headers.items():
        resp.set_header(str(k), str(v))
    if isinstance(status, int):
        status = getattr(falcon, 'HTTP_{}'.format(status))
    resp.status = status
    return resp


def maybe_args(decorator):
    """Decorate a method decorator to make its args optional."""
    def wrapped_decorator(klass, *args):
        if len(args) == 1 and isinstance(args[0], collections.abc.Callable):
            return decorator(klass, *args)
        else:
            def real_decorator(method):
                return decorator(klass, method, *args)
            return real_decorator
    return wrapped_decorator


def redirect(location, code=302):
    response = Response()
    response.status = falcon.HTTP_FOUND
    response.set_header("location", location)
    return response

