import struct
from zipfile import _EndRecData, _ECD_ENTRIES_TOTAL, _ECD_SIZE, _ECD_OFFSET, _ECD_DISK_NUMBER, _ECD_DISK_START, sizeCentralDir, structCentralDir, _CD_SIGNATURE, stringCentralDir

# is_zipfile() gives many false positives, not reliable
# https://bugs.python.org/issue28494
# https://github.com/python/cpython/pull/5053
def my_check_zipfile(fp):
    try:
        endrec = _EndRecData(fp)
        if endrec:
            if endrec[_ECD_ENTRIES_TOTAL] == 0 and endrec[_ECD_SIZE] == 0 and endrec[_ECD_OFFSET] == 0:
                return True     # Empty zipfiles are still zipfiles
            elif endrec[_ECD_DISK_NUMBER] == endrec[_ECD_DISK_START]:
                fp.seek(endrec[_ECD_OFFSET])    # Central directory is on the same disk
                if fp.tell() == endrec[_ECD_OFFSET] and endrec[_ECD_SIZE] >= sizeCentralDir:
                    data = fp.read(sizeCentralDir)   # CD is where we expect it to be
                    if len(data) == sizeCentralDir:
                        centdir = struct.unpack(structCentralDir, data) # CD is the right size
                        if centdir[_CD_SIGNATURE] == stringCentralDir:
                            return True         # First central directory entry  has correct magic number
    except OSError:
        pass
    return False

def is_zipfile(filename):
    """Quickly see if a file is a ZIP file by checking the magic number.

    The filename argument may be a file or file-like object too.
    """
    result = False
    try:
        if hasattr(filename, "read"):
            result = my_check_zipfile(fp=filename)
        else:
            with open(filename, "rb") as fp:
                result = my_check_zipfile(fp)
    except OSError:
        pass
    return result

