'''
Created on Apr 02, 2015

@author: utandon

Copyright (c) 2015-2016 by Cisco Systems, Inc.
All rights reserved.
'''
class RFSComposer(object):
    """
    RFS Composer to get aufs/non aufs composer 
    """
    TYPE_AUFS = "rfs_aufs"
    TYPE_COPY = "rfs_copy"
    TYPE_MOUNT = "rfs_mount"
    TYPE_OVERLAY = "rfs_overlay"
    RFS_TYPES = [TYPE_AUFS, TYPE_COPY, TYPE_MOUNT, TYPE_OVERLAY]
    @classmethod
    def get_rfs_composer(cls, type):
        """
        From the  returns the specific package class
        """
        if type is RFSComposer.TYPE_AUFS:
            from .rootaufs_composer import AUFS_Composer
            return AUFS_Composer.getInstance()
        elif type is RFSComposer.TYPE_COPY:
            from .rootcopy_composer import Copy_Composer
            return Copy_Composer.getInstance()
        elif type is RFSComposer.TYPE_OVERLAY:
            from .rootoverlay_composer import Overlay_Composer
            return Overlay_Composer.getInstance()
        else:
            from .rootmount_composer import Mount_Composer
            return Mount_Composer.getInstance()
