#-----------------------------------------------------
#
# Copyright (c) 2017 by cisco Systems, Inc.
# All rights reserved.
#-----------------------------------------------------


__author__ = "vdattatr"

import logging
log = logging.getLogger("runtime.hosting")
from  .resourcemanager import ResourceManager
from .platformcapabilities import PlatformCapabilities


class GenericResourceManager(ResourceManager):
    __singleton = None  # the one, true Singleton

    def __new__(cls, *args, **kwargs):
        # Check to see if a __singleton exists already for this class
        # Compare class types instead of just looking for None so
        # that subclasses will create their own __singleton objects
        if cls != type(cls.__singleton):
        #if not cls.__singleton:
            cls.__singleton = super().__new__(cls)
        return cls.__singleton

    def __init__(self, cgroup_mount_path=None, cgroup_parent_name=None,
                 cgroup_create_tree = False, cgroup_constant_shares=100,
                 persistent_store=None, use_ext4=False):
        '''
        Donot sub-class this class. If you do, because of singleton code above, init
        would be called multiple times
        '''
        self._cgroup_mount_path = cgroup_mount_path
        self._cgroup_parent_name = cgroup_parent_name
        self._cgroup_create_tree = cgroup_create_tree
        self._cgroup_constant_shares = cgroup_constant_shares
        self._pc = PlatformCapabilities.getInstance()
        self._resource_profiles = None
        self._app_map = {}
        self._app_disks = {}
        self._app_rfsdisks = {}
        self._load_resource_profiles()
        if self._cgroup_create_tree:
            self._initialize_cgroup_partition()
        self._persistent_store = persistent_store
        self._use_ext4 = use_ext4
        if self._persistent_store:
            self._pc.set_persistent_dir(self._persistent_store)
        #self._init_existing_disks(self._persistent_store)

    @classmethod
    def getInstance(cls, *args):
        '''
        Returns a singleton instance of the class
        '''
        if not cls.__singleton:
            cls.__singleton = GenericResourceManager(*args)
        return cls.__singleton


