#-----------------------------------------------------
#
# Copyright (c) 2012 by cisco Systems, Inc.
# All rights reserved.
#-----------------------------------------------------

'''
Created on Sep 28, 2013

@author: havishwa
'''
import os
import logging
import stat
import configparser
from   .stagingplugin import StagingPlugin
from   ..utils.utils import Utils
from ..runtime import runtime

log = logging.getLogger("runtime.hosting")

class GenericLinuxStagingPlugin(StagingPlugin):
    '''
    Base class for processing native binaries
    '''
    def __init__(self, baseDir, connectorArchiveFile, stagingReq, config=None):
        super(self.__class__, self).__init__(baseDir, connectorArchiveFile, stagingReq, config)

    def startStaging(self):
        '''
        Do work and return stagingResponse 
        '''
        self.createConnectorDirectories()
        self.extractArchiveFileToDestination()
        self.createStartScript()
        self.createStopScript()
        self.createCustomScripts()
        self.setupCustomLogFiles()

    def getStartScript(self):
        '''
        Return the startup script.
        Plugin implementations can use the helper methods generateStartScript() and 
        further customize 
        '''
        
        cfg = self._getSystemConfig()
        env = {}
        
        #add connector specified environment variables
        conenv = self.stagingReq.getMetadata().app_env
        if conenv:
            for option, value in list(conenv.items()):
                env[option] = value
            
        customCommands = []
        return self.generateStartScript(env, customCommands)
    
    def getStopScript(self):
        '''
        Return the stop script
        Plugin implementations can use the helper methods generateStopScript() and
        further customize 
        '''
        return self.generateStopScript()

    def getCommandForStart(self):
        """
        Returns the system command to start the connector
        Language plugin implementations must override this
        """
        #TODO: Fix contoller to pass the language runtime path info to staging
        
        #runnerFile = self.stagingReq.getMetadata().mainprocess["runner"]
        runnerFile = self.stagingReq.getMetadata().app_binary
        cmd = []
        if str(runnerFile).endswith(".py"):
            cmd.append("python $CAF_APP_PATH/"+runnerFile)
        else:
            cmd.append("$CAF_APP_PATH/"+runnerFile)

        return " ".join(cmd)

    def getModulesDirectoryName(self):
        return "modules"
    
    def getModulesDirectory(self):
        modulesDir = os.path.join(self.getConnectorDirectory(), self.getModulesDirectoryName())
        return modulesDir

    def getRelativeModulesDirectory(self):
        modulesDir = os.path.join(self.getRelativeConnectorDirectory(), self.getModulesDirectoryName())
        return modulesDir
    
    def createPythonModulesDirectory(self):
        os.mkdir(self.getModulesDirectory())
    
    def copyToolkitFiles(self):
        """
        Copy toolkit files to modules directory.
        """
        return
    
    def _getSystemConfig(self):
        systemConfigPath = Utils.getSystemConfigPath()
        systemConfig = configparser.SafeConfigParser()
        systemConfig.read(systemConfigPath)
        return systemConfig

