'''
Created on Oct 1, 2013

@author: vikasga
'''
import logging
from ..stager import StagingError

log = logging.getLogger("runtime.hosting")

class JavaDeployment(object):
    '''
    classdocs
    '''

    def __init__(self, stagingReq):
        self._stagingReq = stagingReq
    
    def doStaging(self):
        self.doPluginStaging()

    def doPluginStaging(self):
        pass
    
    def getJavaEnvironmentVariables(self, appDirectoryName):
        raise StagingError("Java deployment framework plugin missing  getJavaEnvironmentVariables implementation")
    
    def getCommandForStart(self,appDirectoryName):
        raise StagingError("Java deployment framework plugin missing  getCommandForStart implementation")
    
    def getDefaultExportCommands(self):
        cmd = []
        exp = """
        echo "PATH is: $PATH"
        echo "LD_LIBRARY_PATH is: $LD_LIBRARY_PATH"
        env
        java -version
        if [ $? -eq 0 ]; then
            echo "Could run the JRE to get its version successfully"
        else
            echo "Couldn't run the JRE to get its version"
        fi
        """
        cmd.append(exp)
        # To see if we need to set JAVA_HOME also.
        return cmd
    
    def getDeploymentModeExportCommands(self, appDirectoryName):
        raise StagingError("Java deployment framework plugin missing  getDeploymentModeExportCommands implementation")
    
class DefaultDeployment(JavaDeployment):
    '''
    classdocs
    '''

    def __init__(self, stagingReq):
        JavaDeployment.__init__(self, stagingReq)
        self.metadata = self._stagingReq.getMetadata()
        self.startup = self._stagingReq.getMetadata().startup
        self.runtime_options = self._stagingReq.getMetadata().runtime_options
        
    def doPluginStaging(self):
        pass 
        
    def getEnvironmentVariables(self, appDirectoryName):
        log.debug("java default framework staging with args appDirectoryName:%s", appDirectoryName)
        classpath = self.runtime_options.get("classpath","");
        env ={}
        #classpath = classpath \
         #           + ":$CAF_HOME/"+appDirectoryName+"/lib/*" \
          #          + ":$CAF_HOME/"+appDirectoryName+"/classes/" \
           #         + ":$CAF_HOME/"+appDirectoryName+"/resources/"
                      
        env["CLASSPATH"] = classpath
        
        JAVA_OPTIONS = self.runtime_options.get("java-options","")
        debug_enabled= self.runtime_options.get("java-debug-enabled","false")
        
        DEBUG_OPTIONS= self.runtime_options.get("java-debug-options","")
        if (debug_enabled =="true"): 
            env["JAVA_OPTIONS"]= DEBUG_OPTIONS + " " + JAVA_OPTIONS
        else:
            env["JAVA_OPTIONS"]= JAVA_OPTIONS  
            
        #POST_CLASSPATH = self.startup.get("post-classpath","")
        #env["POST_CLASSPATH"]= POST_CLASSPATH
      
        return env

        
    def getCustomCommands(self, appDirectoryName):
        cmd = self.getDefaultExportCommands()
        return cmd
    
    def getCommandForStart(self, appDirectoryName):
        useLauncher = self.metadata.use_launcher
        if type(useLauncher) != bool:
            useLauncher = useLauncher in ["True", "true", "Yes", "yes"]
        log.debug("java staging useLauncher :%s", useLauncher)

        runnerFile = self.metadata.app_binary

        if ".sh" in runnerFile:
            cmd = "$CAF_APP_PATH/"+runnerFile
        else:
            cmd = "java -cp $CLASSPATH $JAVA_OPTIONS  " + runnerFile
        return cmd
