'''
Created on Sep 27, 2013

@author: vikasga
'''

class JavaDeploymentMode(object):
    """
    Represents the details of specific java deployment deploymentMode
    """
    def __init__(self, deploymentModeId, description, deploymentModePlugin):
        self._deploymentModeId = deploymentModeId
        self._description = description
        self._deploymentModePlugin = deploymentModePlugin
    
    @property
    def id(self):
        return self._deploymentModeId
    
    @property
    def description(self):
        return self._description
    
    @property
    def deploymentModePlugin(self):
        return self._deploymentModePlugin
    
class JavaDeploymentModes(object):
    """
    List of deployment models supported by java toolkit
    """
    def __init__(self):
        self._map = {}
        self._addDeploymentMode(JavaDeploymentMode("default",
                                                   "Default Java VM  based  deployment",
                                                   "appfw.staging.javastaging.deploymentMode.DefaultDeployment"))
        
    def items(self):
        return self._map.values()
    
    def get(self, runtimeId):
        deploymentMode = None
        if runtimeId in self._map:
            deploymentMode = self._map[runtimeId]
        return deploymentMode
    
    def supports(self, deploymentModeId):
        deploymentMode = self.get(deploymentModeId)
        return deploymentMode is not None
    
    def _addDeploymentMode(self, deploymentMode):
        self._map[deploymentMode.id] = deploymentMode
        return deploymentMode
