'''
Copyright (c) 2014 by Cisco Systems, Inc.
All rights reserved.

@author: havishwa
'''

import logging
import shutil
import tempfile
import tarfile
import os
import subprocess
import zipfile
from .stager import StagingResponse
from ..utils.utils import Utils

log = logging.getLogger("runtime.hosting")

class KVMStager(object):
    """
    Stager for docker type application container
    """
    __singleton = None
    
    def __new__(cls, *args, **kwargs):
        # subclasses will create their own __singleton objects
        if cls != type(cls.__singleton):
            cls.__singleton = super(KVMStager, cls).__new__(cls)
        return cls.__singleton

    @classmethod
    def getInstance(cls, *args):
        '''
        Returns a singleton instance of the class
        '''
        if not cls.__singleton:
            cls.__singleton = KVMStager(*args)
        return cls.__singleton

    def __init__(self, config, languageRuntimes=None):
        self._config = config
        
    def stageConnector(self, stagingReq):
        """
        KVM stager simply extracts the inner envelop and use the location
        of original repo. Previously it use to copy the contents which use to take 
        lot of time 819
        """ 
        log.debug("Begin staging for kvm app. AppID: %s" % stagingReq.getConnectorId())
        pkg = stagingReq.getPackageObject()
        if pkg != None:
            staging_location = pkg.dest_dir
            log.debug("kvm app archive %s staging location %s" % (stagingReq.getPackagePath(), staging_location))
        app_config_file_name = Utils.find_app_config_filename(staging_location)
        response = dict()
        response["staged-package-path"] = staging_location
        response["app-config-file-name"] = app_config_file_name
        return StagingResponse(stagingReq.getConnectorId(), stagingReq.getPackagePath(), None, response)

        
    def finish(self, connector, metadata, metadataFile, connectorArchiveFile, stagingResp):
        """
        Finish staging after connector deploys
        """
        if os.path.isfile(metadataFile):
            shutil.copy(metadataFile, connector.getPath())
        log.debug("Staging complete." )

