'''
Copyright (c) 2014 by Cisco Systems, Inc.
All rights reserved.

@author: iyavuz
'''

import logging
import os, shutil
import tarfile
from .stager import StagingResponse
from appfw.utils.utils import Utils
from appfw.app_package.packagemanager import PackageManager

log = logging.getLogger("runtime.hosting")

class VmStager(object):
    """
    Stager for VM type application container
    """
    
    __singleton = None
    
    def __new__(cls, *args, **kwargs):
        # subclasses will create their own __singleton objects
        if cls != type(cls.__singleton):
            cls.__singleton = super(VmStager, cls).__new__(cls)
        return cls.__singleton

    @classmethod
    def getInstance(cls, *args):
        '''
        Returns a singleton instance of the class
        '''
        if not cls.__singleton:
            cls.__singleton = VmStager(*args)
        return cls.__singleton

    def __init__(self, config, languageRuntimes=None):
        self._config = config
        
    def stageConnector(self, stagingReq):
        pkg = PackageManager.getPackage(stagingReq.getPackagePath())
        connectorId = stagingReq.getConnectorId()
        ovaPath = os.path.join(os.path.dirname(stagingReq.getPackagePath()), connectorId + '.ova')
        pkg.rename_archive(ovaPath)
        stagingReq._req["package-path"]=ovaPath

        response = {}
        response["staged-package-path"] = str(stagingReq.getPackagePath())
        return StagingResponse(stagingReq.getConnectorId(), stagingReq.getPackagePath(), None, response)
        
    def finish(self, connector, metadata, metadataFile, connectorArchiveFile, stagingResp):
        """
        Finish staging after connector deploys
        """
        shutil.copy(metadataFile, connector.getPath())
        
        # Copy application config to shared directory for KVM
        if self._config.has_option("vm-container", "shared_dir"):
            appcfgfile = Utils.find_app_config_filename(connector.getPath())
            sharedDir = self._config.get("vm-container", "shared_dir")
            vmSharedDir = os.path.join(sharedDir, connector.id)
            with tarfile.open(connectorArchiveFile, 'r', errors='ignore') as tar:
                if appcfgfile in tar.getnames():
                    tar.extract(appcfgfile, vmSharedDir)
                    log.debug("Extracted appcfg file %s to %s", appcfgfile, vmSharedDir)


