import subprocess
import threading
import logging
import os
import signal

log = logging.getLogger("command_wrapper")

""" Run system commands with timeout
"""
class PipeCommand(object):
    def __init__(self, cmd):
        self.cmd = cmd
        self.process = None
        self.out = ""
        self.err = None
        self.rv = None

    def run_command(self, capture = False, shell=False):
        # Need to run as session leader
        # https://stackoverflow.com/questions/23228650/python-cannot-kill-process-using-process-terminate
        if not capture:
            self.process = subprocess.Popen(self.cmd,shell=shell, preexec_fn=os.setsid)
            self.process.communicate()
            return
        # capturing the outputs of shell commands
        self.process = subprocess.Popen(self.cmd,shell=shell,stdout=subprocess.PIPE,stderr=subprocess.PIPE,stdin=subprocess.PIPE, preexec_fn=os.setsid)
        log.debug("Pipe created for command:%s" % self.cmd)
        out, err= self.process.communicate()
        self.out = (out[:256].decode("utf-8") + '..') if len(out) > 256 else out.decode("utf-8")
        self.out = self.out.splitlines()
        self.rv = self.process.returncode
        self.err = err.decode("utf-8")

    # set default timeout to 2 minutes
    def run(self, capture = False, timeout = 120, sig=signal.SIGTERM, shell=False):
        thread = threading.Thread(target=self.run_command, args=(capture,shell))
        thread.start()
        thread.join(timeout)
        if thread.is_alive():
            log.info('Command timeout, kill it: %s'  % self.cmd)
            #self.process.terminate()
            #self.process.kill()
            os.killpg(self.process.pid, sig)

            thread.join()
        self.rv=self.process.returncode
        log.debug("Task completed return value:%s output:%s error:%s" % (self.rv,self.out, self.err))
        return self.out, self.err, self.rv

