__author__ = 'hvishwanath'

import shutil
import os

class PlatformHandler(object):

    def __init__(self, platform_id):
        self.PRUNE_FILES = [".gitignore", "README"]
        self.PRUNE_DIRS = [".git", "sample-apps", "third-party", "tools", "core/caf/tests", "cartridges", "core/caf/docs"]
        self.PLATFORM_OVERRIDES = []
        self.PYSTDLIB = []
        self._platform_id = platform_id

    @property
    def platform_id(self):
        return self._platform_id


    def get_prune_files(self):
        """
        Return a list of files to be removed from the target build
        """
        return self.PRUNE_FILES

    def get_prune_dirs(self):
        """
        Return a list of directories to be removed from the target build
        """
        return self.PRUNE_DIRS

    def get_platform_overrides(self):
        """
        Return a list of files that needs to be overridden from platform specific code
        """
        return self.PLATFORM_OVERRIDES

    def get_pystdlib(self):
        """
        Return a list of standard python lib files that needs to be copied from build machine to target build
        """
        return self.PYSTDLIB

    def get_platform_package_list(self, genericlist, with_rest_api=True):
        return genericlist


    def get_package_target_dir(self):
        """
        Return a relative directory to where dependencies have to be installed
        """
        return "local/lib"

    def get_pystdlib_target_dir(self):
        """
        Return a relative directory to where dependencies have to be installed
        """
        return "local/pystdlib"

    def post_process(self, build_root):
        return


class BarbadosHandler(PlatformHandler):
    def __init__(self, platform_id="barbados"):
        super(BarbadosHandler, self).__init__(platform_id)
        self.PLATFORM_OVERRIDES = [("platform/barbados/config/device_config.yaml",
                                    "core/caf/config/device_config.yaml"),
                                   ("platform/barbados/config/capabilities/barbados.yaml",
                                    "core/caf/config/capabilities/barbados.yaml"),
                                   ]
        self.PYSTDLIB = ["/usr/lib/python2.7/netrc.py",
                         "/usr/lib/python2.7/argparse.py",
                         "/usr/lib/python2.7/wsgiref",
                         "/usr/lib/python2.7/fileinput.py",
                         "/usr/lib/python2.7/ast.py",
                         "/usr/lib/python2.7/dist-packages/pkg_resources.py"]

    def post_process(self, build_root):
        # Move caf and lm into build root
        # Copy tpminterface

        print "Moving CAF to build root"
        shutil.move("core/caf", os.path.join(build_root, "caf"))

    def get_platform_package_list(self, genericlist, with_rest_api=True):
        package_list = list(genericlist)
        rmlist = ["psutil", "libvirt", "docker-py", "requests", "mock", "websocket-client", "pam"]
        rmlist += ["idna", "pycparser", "pyasn1", "cffi", "cryptography", "pyOpenSSL", "setuptools"]
        rmlist += ["cheroot", "pyudev", "libvirt-py", "enum", "concurrent", "six"]

        for r in rmlist:
            # Remove the item from package list.
            [package_list.remove(x) if r in x else "" for x in list(package_list)]
            print "Removed %s from package list" % r

        if not with_rest_api:
            # Remove the following libraries
            [package_list.remove(x) if "CherryPy" in x else "" for x in list(package_list)]
            [package_list.remove(x) if "falcon" in x else "" for x in list(package_list)]
            [package_list.remove(x) if "python-mimeparse" in x else "" for x in list(package_list)]

        return package_list

class APVirtualHandler(PlatformHandler):
    def __init__(self, platform_id="apvirtual"):
        super(APVirtualHandler, self).__init__(platform_id)
        self.PLATFORM_OVERRIDES = [("platform/apvirtual/config/capabilities/apvirtual.yaml",
                                    "core/caf/config/capabilities/apvirtual.yaml"),
                                   ("platform/apvirtual/config/device_config.yaml",
                                    "core/caf/config/device_config.yaml"),
                                   ]
        self.PYSTDLIB = ["/usr/lib/python2.7/netrc.py",
                         "/usr/lib/python2.7/argparse.py",
                         "/usr/lib/python2.7/wsgiref",
                         "/usr/lib/python2.7/fileinput.py",
                         "/usr/lib/python2.7/ast.py",
                         "/usr/lib/python2.7/dist-packages/pkg_resources.py"]

    def post_process(self, build_root):
        # Move caf and lm into build root
        # Copy tpminterface

        print "Moving CAF to build root"
        shutil.move("core/caf", os.path.join(build_root, "caf"))

    def get_platform_package_list(self, genericlist, with_rest_api=True):
        package_list = list(genericlist)
        rmlist = ["psutil", "libvirt", "docker-py", "requests", "mock", "websocket-client", "pam"]
        rmlist += ["idna", "pycparser", "pyasn1", "cffi", "cryptography", "pyOpenSSL", "setuptools"]
        rmlist += ["cheroot", "pyudev", "libvirt-py", "enum", "concurrent", "six"]

        for r in rmlist:
            # Remove the item from package list.
            [package_list.remove(x) if r in x else "" for x in list(package_list)]
            print "Removed %s from package list" % r

        if not with_rest_api:
            # Remove the following libraries
            [package_list.remove(x) if "CherryPy" in x else "" for x in list(package_list)]
            [package_list.remove(x) if "falcon" in x else "" for x in list(package_list)]
            [package_list.remove(x) if "python-mimeparse" in x else "" for x in list(package_list)]

        return package_list

class AxelBcmHandler(PlatformHandler):
    def __init__(self, platform_id="axel-bcm"):
        super(AxelBcmHandler, self).__init__(platform_id)
        self.PLATFORM_OVERRIDES = [("platform/axel-bcm/config/device_config.yaml",
                                    "core/caf/config/device_config.yaml"),
                                   ("platform/axel-bcm/config/capabilities/axel-bcm.yaml",
                                    "core/caf/config/capabilities/axel-bcm.yaml"),
                                   ]
        self.PYSTDLIB = ["/usr/lib/python2.7/netrc.py",
                         "/usr/lib/python2.7/argparse.py",
                         "/usr/lib/python2.7/wsgiref",
                         "/usr/lib/python2.7/fileinput.py",
                         "/usr/lib/python2.7/ast.py",
                         "/usr/lib/python2.7/dist-packages/pkg_resources.py"]

    def post_process(self, build_root):
        # Move caf and lm into build root
        # Copy tpminterface

        print "Moving CAF to build root"
        shutil.move("core/caf", os.path.join(build_root, "caf"))

    def get_platform_package_list(self, genericlist, with_rest_api=True):
        package_list = list(genericlist)
        rmlist = ["psutil", "libvirt", "docker-py", "requests", "mock", "websocket-client", "pam"]
        rmlist += ["idna", "pycparser", "pyasn1", "cffi", "cryptography", "pyOpenSSL", "setuptools"]
        rmlist += ["cheroot", "pyudev", "libvirt-py", "enum", "concurrent", "six"]

        for r in rmlist:
            # Remove the item from package list.
            [package_list.remove(x) if r in x else "" for x in list(package_list)]
            print "Removed %s from package list" % r

        if not with_rest_api:
            # Remove the following libraries
            [package_list.remove(x) if "CherryPy" in x else "" for x in list(package_list)]
            [package_list.remove(x) if "falcon" in x else "" for x in list(package_list)]
            [package_list.remove(x) if "python-mimeparse" in x else "" for x in list(package_list)]

        return package_list

class AxelQcaHandler(PlatformHandler):
    def __init__(self, platform_id="axel-qca"):
        super(AxelQcaHandler, self).__init__(platform_id)
        self.PLATFORM_OVERRIDES = [("platform/axel-qca/config/device_config.yaml",
                                    "core/caf/config/device_config.yaml"),
                                   ("platform/axel-qca/config/capabilities/axel-qca.yaml",
                                    "core/caf/config/capabilities/axel-qca.yaml"),
                                   ]
        self.PYSTDLIB = ["/usr/lib/python2.7/netrc.py",
                         "/usr/lib/python2.7/argparse.py",
                         "/usr/lib/python2.7/wsgiref",
                         "/usr/lib/python2.7/fileinput.py",
                         "/usr/lib/python2.7/ast.py",
                         "/usr/lib/python2.7/dist-packages/pkg_resources.py"]

    def post_process(self, build_root):
        # Move caf and lm into build root
        # Copy tpminterface

        print "Moving CAF to build root"
        shutil.move("core/caf", os.path.join(build_root, "caf"))

    def get_platform_package_list(self, genericlist, with_rest_api=True):
        package_list = list(genericlist)
        rmlist = ["psutil", "libvirt", "docker-py", "requests", "mock", "websocket-client", "pam"]
        rmlist += ["idna", "pycparser", "pyasn1", "cffi", "cryptography", "pyOpenSSL", "setuptools"]
        rmlist += ["cheroot", "pyudev", "libvirt-py", "enum", "concurrent", "six"]

        for r in rmlist:
            # Remove the item from package list.
            [package_list.remove(x) if r in x else "" for x in list(package_list)]
            print "Removed %s from package list" % r

        if not with_rest_api:
            # Remove the following libraries
            [package_list.remove(x) if "CherryPy" in x else "" for x in list(package_list)]
            [package_list.remove(x) if "falcon" in x else "" for x in list(package_list)]
            [package_list.remove(x) if "python-mimeparse" in x else "" for x in list(package_list)]

        return package_list

class MallorcaHandler(PlatformHandler):
    def __init__(self, platform_id="mallorca"):
        super(MallorcaHandler, self).__init__(platform_id)
        self.PLATFORM_OVERRIDES = [("platform/mallorca/config/capabilities/mallorca.yaml",
                                    "core/caf/config/capabilities/mallorca.yaml"),
                                   ("platform/mallorca/config/device_config.yaml",
                                    "core/caf/config/device_config.yaml"),
                                   ]
        self.PYSTDLIB = ["/usr/lib/python2.7/netrc.py",
                         "/usr/lib/python2.7/argparse.py",
                         "/usr/lib/python2.7/wsgiref",
                         "/usr/lib/python2.7/fileinput.py",
                         "/usr/lib/python2.7/ast.py",
                         "/usr/lib/python2.7/dist-packages/pkg_resources.py"]

    def post_process(self, build_root):
        # Move caf and lm into build root
        # Copy tpminterface

        print "Moving CAF to build root"
        shutil.move("core/caf", os.path.join(build_root, "caf"))

    def get_platform_package_list(self, genericlist, with_rest_api=True):
        package_list = list(genericlist)
        rmlist = ["psutil", "libvirt", "docker-py", "requests", "mock", "websocket-client", "pam"]
        rmlist += ["idna", "pycparser", "pyasn1", "cffi", "cryptography", "pyOpenSSL", "setuptools"]
        rmlist += ["cheroot", "pyudev", "libvirt-py", "enum", "concurrent", "six"]

        for r in rmlist:
            # Remove the item from package list.
            [package_list.remove(x) if r in x else "" for x in list(package_list)]
            print "Removed %s from package list" % r

        if not with_rest_api:
            # Remove the following libraries
            [package_list.remove(x) if "CherryPy" in x else "" for x in list(package_list)]
            [package_list.remove(x) if "falcon" in x else "" for x in list(package_list)]
            [package_list.remove(x) if "python-mimeparse" in x else "" for x in list(package_list)]

        return package_list
class VegaHandler(PlatformHandler):
    def __init__(self, platform_id="vega"):
        super(VegaHandler, self).__init__(platform_id)
        self.PLATFORM_OVERRIDES = [("platform/vega/config/system-config.ini",
                                    "core/caf/config/system-config.ini"),
                                   ("platform/vega/scripts/run-caf.sh",
                                    "core/caf/scripts/run-caf.sh"),
                                   ("platform/vega/scripts/show_tech_support.sh",
                                    "core/caf/scripts/show_tech_support.sh"),
                                   ("platform/vega/config/network_config.yaml",
                                    "core/caf/config/network_config.yaml"),
                                    ("platform/vega/config/security_config.yaml",
                                    "core/caf/config/security_config.yaml"),
                                   ("platform/vega/config/device_config.yaml",
                                    "core/caf/config/device_config.yaml"),
                                   ("platform/vega/scripts/setupconsole.sh",
                                    "core/caf/scripts/setupconsole.sh"),
                                   ("platform/vega/scripts/setupscpuser.sh",
                                    "core/caf/scripts/setupscpuser.sh"),
                                   ("platform/vega/config/update_config.yaml",
                                    "core/caf/config/update_config.yaml"),
                                   ("platform/vega/scripts/upgrade-caf.sh",
                                    "core/caf/scripts/upgrade-caf.sh")
                                   ]
        self.PYSTDLIB = ["/usr/lib/python2.7/netrc.py",
                         "/usr/lib/python2.7/argparse.py",
                         "/usr/lib/python2.7/wsgiref",
                         "/usr/lib/python2.7/fileinput.py",
                         "/usr/lib/python2.7/ast.py"]

    def post_process(self, build_root):
        # Move caf and lm into build root
        # Copy tpminterface

        print "Moving CAF to build root"
        shutil.move("core/caf", os.path.join(build_root, "caf"))


    def get_platform_package_list(self, genericlist, with_rest_api=True):
        package_list = list(genericlist)
        rmlist = ["psutil", "libvirt", "docker-py", "requests", "mock", "websocket-client", "pam"]
        rmlist += ["idna", "pycparser", "pyasn1", "cffi", "cryptography", "pyOpenSSL", "setuptools"]

        for r in rmlist:
            # Remove the item from package list.
            [package_list.remove(x) if r in x else "" for x in list(package_list)]
            print "Removed %s from package list" % r

        if not with_rest_api:
        # Remove the following libraries
            [package_list.remove(x) if "CherryPy" in x else "" for x in list(package_list)]
            [package_list.remove(x) if "falcon" in x else "" for x in list(package_list)]
            [package_list.remove(x) if "python-mimeparse" in x else "" for x in list(package_list)]

        return package_list

BuildHandlerMap = {
    "barbados": BarbadosHandler,
    "apvirtual": APVirtualHandler,
    "axel-bcm": AxelBcmHandler,
    "axel-qca": AxelQcaHandler,
    "mallorca": MallorcaHandler,
    "vega": VegaHandler,
}
