'''
Created on Jul 14, 2014

@author: utandon

Copyright (c) 2012-2013 by Cisco Systems, Inc.
All rights reserved.
'''
import json
import falcon

from apiservice import  ResourceRoute, APIService
from common import AuthenticatedResource, make_response, make_error_response
import logging
log = logging.getLogger("cafmetrics")

from jsonencoder import JSONEncoder
jsonencoder = JSONEncoder()
from ..utils.infraexceptions import *

@ResourceRoute("/cafmetrics", endpoint="cafmetrics")
class CAFMetricsResourceHandler(AuthenticatedResource):

    def on_get(self, request, response):
        app_manager = APIService.instance.app_manager
        if app_manager == None:
            log.error("App manager is disabled")
            response = make_error_response(response,
                                           "App manager is disabled",
                                           "App manager is disabled",
                                           falcon.HTTP_503)
            return
        if not app_manager.is_caf_metrics_enabled():
            make_error_response(response, "stats are not available", "stats are not available", falcon.HTTP_503)
            return
        stats_types = app_manager.get_stats_types()
        log.debug("Stats types: %s" % str(stats_types))
        datastr = json.dumps(stats_types)
        log.debug("Caf metrics: %s" % datastr)
        response = make_response(response, datastr, falcon.HTTP_200)
        response.set_header('Content-Type', "application/json")
        response.set_header('Cache-Control', "no-cache")


@ResourceRoute("/cafmetrics/{stats_type}", endpoint="cafmetrics")
class StatsResourceHandler(AuthenticatedResource):
    def on_get(self, request, response, stats_type):
        try:
            app_manager = APIService.instance.app_manager
            if not app_manager.is_caf_metrics_enabled():
                make_error_response(response, "stats are not available", "stats are not available", falcon.HTTP_503)
                return
            if stats_type == "all":
                cafMetrics = app_manager.get_caf_metrics(regtype=None)
            else:
                cafMetrics = app_manager.get_caf_metrics(regtype=stats_type)
            datastr = json.dumps(cafMetrics)
            log.debug("Caf metrics: %s" % datastr)
            response = make_response(response, datastr, falcon.HTTP_200)
            response.set_header('Content-Type', "application/json")
            response.set_header('Cache-Control', "no-cache")
        except MetricsNotFoundException as ex:
            log.exception("Error getting caf metrics")
            response = make_error_response(response,
                                           ex.message,
                                           "Error getting %s details" % stats_type,
                                           falcon.HTTP_404
                                           )
        except Exception as ex:
            log.exception("Error getting caf metrics")
            response = make_error_response(response,
                                           ex.message,
                                           "Error getting %s details" % stats_type,
                                           falcon.HTTP_500
                                           )
        

@ResourceRoute("/cafmetrics_config", endpoint="cafmetrics_config")
class StatsConfigResource(AuthenticatedResource):

    def on_get(self, request, response):
        app_manager = APIService.instance.app_manager
        config = app_manager.get_stats_config()
        response.status = falcon.HTTP_200
        response.body = jsonencoder.encode(config)
        response.set_headers({'Content-Type': "application/json",
                              'Cache-Control': "no-cache"})

    def on_put(self, request, response):
        app_manager = APIService.instance.app_manager

        try:
            config = json.load(request.stream)
            log.debug("Request to update stats config to %s", config)
            app_manager.set_stats_config(config)

            app_manager.set_stats_config(config)
            response.status = falcon.HTTP_200
            response.body = jsonencoder.encode(config)
            response.set_headers({'Content-Type': "application/json",
                                  'Cache-Control': "no-cache"})
        except ValueError as ve:
            log.exception("Value error in incoming payload")

            response = make_error_response(response,
                      "Invalid request payload : %s" % str(ve),
                      "Invalid request payload",
                      falcon.HTTP_400)

        except Exception as ex:
            log.exception("Error setting stats config")
            if isinstance(ex, C3Exception):
                response = make_error_response(response, ex.message,
                                               "Error setting stats config",
                                               falcon.HTTP_500,
                                               ex.errorcode)
            else:
                response = make_error_response(response,
                          "Error setting stats config: %s" % str(ex),
                          "Error setting stats config",
                          falcon.HTTP_500)

        return

