__author__ = 'madawood'


class SchemaGenerator(object):
    """
    Schema generator : Will generate the schema depends on the version asked for.
    """
    from descriptorschema_1_0 import PackageDescriptorV1
    from descriptorschema_2_0 import PackageDescriptorV2
    from descriptorschema_2_1 import PackageDescriptorV2_1
    from descriptorschema_2_2 import PackageDescriptorV2_2
    from descriptorschema_2_3 import PackageDescriptorV2_3
    from descriptorschema_2_4 import PackageDescriptorV2_4
    from descriptorschema_2_5 import PackageDescriptorV2_5
    from descriptorschema_2_6 import PackageDescriptorV2_6
    from descriptorschema_2_7 import PackageDescriptorV2_7
    from descriptorschema_2_8 import PackageDescriptorV2_8
    from descriptorschema_2_9 import PackageDescriptorV2_9
    from descriptorschema_2_10 import PackageDescriptorV2_10
    class_version_map = {"1.0": PackageDescriptorV1, "2.0": PackageDescriptorV2, "2.1": PackageDescriptorV2_1, "2.2": PackageDescriptorV2_2, "2.3": PackageDescriptorV2_3, "2.4": PackageDescriptorV2_4, "2.5": PackageDescriptorV2_5, "2.6":PackageDescriptorV2_6, "2.7":PackageDescriptorV2_7, "2.8":PackageDescriptorV2_8, "2.9":PackageDescriptorV2_9, "2.10":PackageDescriptorV2_10}

    @classmethod
    def generate_schema(cls, version):
        #version = raw_input("Enter the version for what you want to generate the schema")
        if str(version) in cls.class_version_map:
            generator = cls.class_version_map[str(version)]
            print "Generating schema: version %s"%version
            return generator.get_schema(ordered=False)
        else:
            return None

if __name__ == "__main__":
    import os
    import json

    p = os.path.dirname(os.path.abspath(__file__))
    p = os.path.split(p)[0]  # get appfw
    p = os.path.split(p)[0]  # get src directory
    p = os.path.split(p)[0]  # get caf directory

    config_dir = os.path.join(p, "config")
    print "Config Directory: %s" % config_dir

    ver = ["1.0", "2.0", "2.1", "2.2", "2.3", "2.4",
           "2.5", "2.6", "2.7", "2.8", "2.9", "2.10"]

    for v in ver:
        schemafilename = "schema_"+v+".json"
        svs = os.path.join(config_dir, schemafilename)

        print "Generating Schema V%s at %s" % (v, svs)
        file(svs, "w").write(json.dumps(SchemaGenerator.generate_schema(v), indent=2))
