#-----------------------------------------------------
#
# Copyright (c) 2012-2013 by Cisco Systems, Inc.
# All rights reserved.
#-----------------------------------------------------

__author__ = 'hvishwanath'

class C3Exception(Exception):
    def __init__(self, *args, **kwargs):
        self.errorcode = -1
        super(Exception, self).__init__(*args, **kwargs)

class DuplicateAppIDError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1001

class AppDoesNotExistError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1002

class AppInstallationError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1003

class AppUpgradeError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1004

class AppConfigurationError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1005
        
class DeploymentLimitError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1006
        
class RunningLimitError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1007

class MalformedManifestError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1008

class MandatoryFileMissingError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1009

class IntegrityCheckFailedError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1010

class InvalidSignatureError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1011

class PackageInvalidError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1012

class ServiceDepenendencyError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1013

class AppStartError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1014

class AppStopError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1015

class ResourceLimitError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1016

class CartridgeDependError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1017

class CartridgeDescriptorValidationError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1018

class InvalidStateTransitionError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1019

class NetworkConfigurationError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1020

class AppActivationError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1021

class AppDeActivationError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1022

class InvalidResourceProfileError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1023

class MandatoryDataMissingError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1024

class SchemaValidationError(C3Exception):
    """
    Parse the JSONSchema SchemaErrorList and populate with readable message.
    """
    def __init__(self, *args, **kwargs):
        self.errorcode = -1025
        # We need this info. If the raiser doesn't pass this, let there be a KeyError and cascade
        self.validation_errors = kwargs["validation_errors"]
        self.strrep = dict()

        self.strrep["total_errors"] = len(self.validation_errors)
        self.strrep["error_list"] = []
        for e in self.validation_errors:
            d = dict()
            d["message"] = e.message
            d["absolute_path"] = "/".join([str(i) for i in e.absolute_path])
            d["absolute_schema_path"] = "/".join([str(i) for i in e.absolute_schema_path])
            d["validator_value"] = str(e.validator_value)
            self.strrep["error_list"].append(d)
        self.message = self.__str__()
        super(C3Exception, self).__init__(args, kwargs)

    def __str__(self):
        import json
        return json.dumps(self.strrep)

    def __repr__(self):
        return self.__str__()

class DeviceUnsupportedError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1026

class DeviceConfigurationError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1027

class ConsoleDisabledError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1028

class SecurityConfigError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1029

class StagingError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1030

class StagingDirectoryError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1031

class PlatformCompatibilityError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1032

class FilePathError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1033

class NetworkManagementError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1034

class NetworkNotExistingError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1035

class InvalidDescriptorError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1036

class ScpDisabledError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1037

class DockerRegError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1038

class NetworkConnectionError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1039

class QueueException(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1040

class WebSockConnectionError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1041

class HaSyncError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1042
        
class LifecycleHookFatalError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1043

class MetricsNotFoundException(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1044

class InvalidConfigError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1045

class LayerDoesNotExistError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1046

class PathDoesNotExist(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1047

class IsNotADirectory(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1048

class AlreadyMounted(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1049

class InvalidOverlayFS(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1050

class OverlayFSDoesNotExist(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1051

class UnrecognizedMountEntry(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1052

class LayerDependencyError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1053

class PackageDependencyError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1054

class DAGValidationError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1055

class DeleteRunningAppDataDiskError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1056

class NoAppDataDiskError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1057

class ResourceManagerUnavailableError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1058

class DatastoreLimitError(C3Exception):
    """ 
    Exception class for the case when the number of keys stored
    by datastore service reaches the supported limit.
    """
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1059

class InvalidDataPointError(C3Exception):
    """ 
    Exception class for the case when datapoint received
    is missing in metadata of the app
    """
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1060

class IOXVDataPointLimitError(C3Exception):
    """ 
    Exception class for the case when datapoint received
    is missing in metadata of the app
    """
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1061

class SLAShutdownFailed(C3Exception):
    """
    Exception class for the case when smart license service
    failed to shutdown cleanly
    """
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1062

class SLAPlatformInitEventFailed(C3Exception):
    """
    Exception class for the case when smart license service
    failed to send platform initialized event to agent thread
    """
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1063

class SLAPersistConfigEventFailed(C3Exception):
    """
    Exception class for the case when smart license service
    failed to send persist configuration event to agent thread
    """
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1064

class SLASetGlobalCBFailed(C3Exception):
    """
    Exception class for the case when smart license service
    failed to register global notification callback
    """
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1065

class SLASetEntitlementCBFailed(C3Exception):
    """
    Exception class for the case when smart license service
    failed to register entitlement notification callback
    """
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1066

class SLAAgentInitFailed(C3Exception):
    """
    Exception class for the case when smart license service
    failed to initialize smart agent
    """
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1067

class SLAPlatformBeginConfigReadFailed(C3Exception):
    """
    Exception class for the case when smart license service
    failed to send begin config read event to smart agent thread
    """
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1068

class SLAPlatformEndConfigReadFailed(C3Exception):
    """
    Exception class for the case when smart license service
    failed to send end config read event to smart agent thread
    """
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1069

class ApplogFileFetchingError(C3Exception):
    """
    Exception class for the case when fetching app logs metadata/contents
    failed.
    """
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1070
class SwUpdateActivationError(C3Exception):
    '''
    Exception class for the case when sw update activation fails
    '''
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1071

class SwUpdatePlatformDependencyError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1072

class SwUpdateStateError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1073

class SwUpdateMaxLimitError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1074

class SwUpdateIOxVersionError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1075

class PlatformDiagnosticNotSupported(C3Exception):
    """ 
    Exception class for the case when datapoint received
    is missing in metadata of the app
    """
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1076

class AppUnInstallError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1077

class AppFilesSupportError(C3Exception):
    """
    Exception for CAF not able to handle certain files in app package
    """
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1078

class OverlayMountException(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1079

class AppTypeNotSupportedError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1080

class AppProfileError(C3Exception):
    def __init__(self, *args, **kwargs):
        super(C3Exception, self).__init__(*args, **kwargs)
        self.errorcode = -1081
