import logging
import cgi
from appfw.utils.utils import Utils

log = logging.getLogger("runtime.api")



class MultiPartParser(cgi.FieldStorage):

    def __init__(self, *args, **kwargs):
        cgi.FieldStorage.__init__(self, *args, **kwargs)

    def make_file(self, binary=None):
        tmpUploadDir = Utils.getSystemConfigValue('controller', 'upload_dir', '/tmp')
        import tempfile
        return tempfile.TemporaryFile("w+b", dir=tmpUploadDir) 


class MultipartMiddleware(object):

    def __init__(self, parser=None):
        self.parser = parser or MultiPartParser

    def parse(self, stream, environ):
        return self.parser(fp=stream, environ=environ)


    def process_request(self, req, resp, **kwargs):

        if 'multipart/form-data' not in (req.content_type or ''):
            return

        log.debug("Processing multipart request")
        # This must be done to avoid a bug in cgi.FieldStorage.
        req.env.setdefault('QUERY_STRING', '')

        form = self.parse(stream=req.stream, environ=req.env)
        for key in form:
            field = form[key]
            if not getattr(field, 'filename', False):
                field = form.getlist(key)
            # TODO: put files in req.files instead when #493 get merged.
            req._params[key] = field

