#!/bin/bash
#
#This script uses rsync to sync the data from active to standby rp
# Input arguments to the script:
# SRC: source directory on active rp to sync
# DST: Destination direcory on standby where to sync
# EXCLUDE_LIST_FILE: File conaining list of pattern subdir to exclude from syncing
# IO_TIMEOUT: Max time to wait in seconds for i/o operation to complete
# CONN_TIMEOUT: Max time to wait in seconds for connecting to the other rp 
#

SRC=$1
DST=$2
EXCLUDE_LIST_FILE=$3
IO_TIMEOUT=$4
CONN_TIMEOUT=$5

rsync_caf_data() {
   #dname=$1

   #udevice=$(to_upper_case $dname)

    #mkdir -p $HWPRG_UPGRADE_LOCAL_DIR/$udevice

    #if ! rsync_output=$(rsync \
    #         rsync://$RSYNC_HOST/$RSYNC_ROOT/$BOARD_TYPE/$BINOS_SLOT/$BOARD_SUBTYPE/$udevice/* \
    #         $HWPRG_UPGRADE_LOCAL_DIR/$udevice/. \
    #         2>&1); then

    #   echo -n $SLV_RSYNC_FAIL
    #   return
    #fi
    #echo -n $SLV_BOOTUP
    #return
#rsync --exclude-from /bootflash/sync_exclude.lst  --size-only  -t -r -p -P --timeout 5 -m /bootflash/caf/* rsync://rp0-1/bootflash/cafdup/. --timeout 60

   echo "rsync: rsync --exclude-from $EXCLUDE_LIST_FILE  -t -r -p -P -m $SRC $DST --timeout $IO_TIMEOUT"
   if !  rsync_output=$(rsync --exclude-from $EXCLUDE_LIST_FILE -t -r -avp -m $SRC $DST --timeout $IO_TIMEOUT) ; then
       echo "rsync_output fail: $rsync_output"
       return 1
    fi
    echo "rsync_output success $rsync_output"
    return 0

}
rsync_caf_data
retval=$?
echo "rsync_caf_data returned $retval"
exit $retval

