__author__ = 'hvishwanath'

from  ..libvirtxmlutils import LibvirtXMLGenerator
from appfw.runtime.hostingmgmt import HostingManager
from   ....utils.utils import Utils
import os


USB_HOSTDEV_BY_ADDR_XML = \
"    <hostdev mode='subsystem' type='usb' managed='yes'>\n\
          <source>\n\
            <address bus='{BN}' device='{DN}'/>\n\
          </source>\n\
    </hostdev>"

CHARDEV_XML = """
        <hostdev mode='capabilities' type='misc'>
            <source>
                <char>{DEVICE_ID}</char>
            </source>
        </hostdev>
        """

FILESYSTEM_XML = """
    <filesystem type="{FSTYPE}" accessmode='{ACCESSMODE}'>
        {DRIVER}
        {SOURCE}
        <target dir="{DST_DIR}"/>
        {PERM}
    </filesystem>
                """

FS_DRIVER_XML = """ <driver type='{DRVPATH}' wrpolicy='{WRPOLICY}'/>"""
FS_SOURCE_DIR_XML = """<source dir="{SOURCE_DIR}"/>"""
FS_SOURCE_USAGE_XML = """<source usage="{USAGE}" units="{UNITS}"/> """

CAPABILITIES_XML = """
    <capabilities policy='{POLICY}'>
    {CAPS_DETAILS}
    </capabilities>
"""

FEATURE_CAPABILITIES_XML ="""
  <features>
    {PRIVNET}
    {CAPABILITIES}
  </features>
"""

DEFAULT_FEATURE_CAPABILITIES_XML = """
<features>
    <capabilities policy='default'>
        <mac_override state='off'/>
        <sys_ptrace state='off'/>
        <sys_boot state='off'/>
        <mknod state='off'/>
        <audit_write state='off'/>
        <setfcap state='off'/>
        <setpcap state='off'/>
        <sys_nice state='off'/>
        <sys_pacct state='off'/>
        <sys_rawio state='off'/>
        <sys_resource state='off'/>
        {NET_ADMIN}
    </capabilities>
</features>
"""

SECLABEL_SMACK_XML = """
<seclabel type='static' model='smack' relabel='yes'>
  <label>{SEC_LABEL}</label>
</seclabel>
"""

SECLABEL_SELINUX_XML = """
<seclabel type='static' model='selinux' relabel='no'>
  <label>{SEC_LABEL}</label>
</seclabel>
"""

class LXCLibvirtXMLGenerator(object):

    @classmethod
    def generate_libvirt_lxc_xml(cls, appid, memory, cpu, cgroup_parent, rootfs, vcpu,
                                 emulator="/usr/lib/libvirt/libvirt_lxc",
                                 source_network_list=None,
                                 env=None,
                                 mount_list=None,
                                 device_list=None,
                                 startup="/sbin/init",
                                 sec_attr=None,
                                 chardev_list=None,
                                 features=None,
                                 dhcp_filters={},
                                 filesystem=None,
                                 ramfs=None,
                                 user="",
                                 group="",
                                 currentdir="",
                                 args=None):
        """
        Generate a compatible libvirt xml file from CAF specific app manifest yaml file.
        :param appmanifest:
        :return:
        """

        domain_type = "'lxc'"
        net_admin = ""
        osxml= """
    <os>
      <type>exe</type>
      <!-- <init>"/bin/sh /sensorbot.sh"</init> -->
      <init>{STARTUP}</init>
      {ARGS}
      {CURRENTDIR}
      {USER}
      {GROUP}
    </os>
              """
        args_entry = ""
        current_dir_entry = ""
        user_entry = ""
        group_entry = ""
        if args:
            if isinstance(args, list):
                pass
            elif isinstance(args, basestring):
                args = args.split()
            else:
                raise ValueError("Invalid value provided for args: %s"%args)
            for arg in args:
                args_entry = args_entry + """<initarg>{ARG}</initarg>\n""".format(ARG=arg)
        if currentdir:
            current_dir_entry = """<initdir>{CURRENT_DIR}</initdir>\n""".format(CURRENT_DIR=currentdir)
        if user:
            user_entry = """<inituser>{USER}</inituser>\n""".format(USER=user)
        if group:
            group_entry = """<initgroup>{GROUP}</initgroup>\n""".format(GROUP=group)
        osxml = osxml.format(STARTUP=startup, ARGS=args_entry, CURRENTDIR=current_dir_entry, USER=user_entry, GROUP=group_entry)

        root_fs = """
      <filesystem type="mount" >
         <source dir="{ROOTFS}"/>
         <target dir="/"/>
      </filesystem>
                """
        root_fs = root_fs.format(ROOTFS=rootfs)

        if mount_list and len(mount_list) > 0:
            mount_xml = ""
            for mount_point in mount_list:
                if os.path.isdir(mount_point["src_dir"]):
                    mount_xml += """
        <filesystem type="mount" accessmode='squash'>
            <driver type='path' wrpolicy='immediate'/>
            <source dir="{SOURCE_DIR}"/>
            <target dir="{DST_DIR}"/>
            {PERM}
        </filesystem>
                    """
                else:
                    mount_xml += """
        <filesystem type="file" accessmode='squash'>
            <source file="{SOURCE_DIR}"/>
            <target dir="{DST_DIR}"/>
            {PERM}
        </filesystem>
                    """
                if mount_point["perm"] == "rw":
                    perm=""
                else:
                    perm="<readonly/>"
                mount_xml = mount_xml.format(SOURCE_DIR=mount_point["src_dir"],
                            DST_DIR=mount_point["dst_dir"], PERM=perm)

        else:
            mount_xml ="<!-- NO Extra mounts -->"
        nw_filter_template = """<filterref filter='{NAME}'/>"""
        if source_network_list:
            interface=""
            static_intf = 0
            for source_network in source_network_list:
                interface_name = source_network["interface_name"]
                libvirt_network = source_network["libvirt_network"]
                mac_address = source_network["mac_address"]
                mode = source_network.get("mode")
                ipv4 = source_network.get("ipv4")
                ipv6 = source_network.get("ipv6")

                interface += """

    <interface type='network'>
      <guest dev='{INTERFACE_NAME}' />
      <source network='{SOURCE_NETWORK}' />
      {MAC_ENTRY}
      {STATIC_IP}
      {ROUTE}
      {FILTER}
    </interface>

        """
                if mac_address:
                    mac_entry = """<mac address='{MAC_ADDRESS}' />""".format(MAC_ADDRESS=mac_address)
                else:
                    mac_entry = ""
                # Assigning the static ip for the interface.
                static_ip = ""
                route = ""
                nwfilter = ""
                static_ipv4 = False
                static_ipv6 = False
                #if mode == 'static':
                for ip_fam in "ipv4", "ipv6":
                    static_data = source_network.get(ip_fam)
                    if static_data:
                        if mode == 'static' or static_data.get('mode') == 'static':
                            if ip_fam == "ipv4":
                                static_ipv4 = True
                            if ip_fam == "ipv6":
                                static_ipv6 = True
                            ip = static_data['ip']
                            prefix = static_data['prefix']
                            # Gateway only needed if user want to add route
                            gateway = static_data.get('gateway')
                            static_ip += """<ip address='{IP}' family='{FAMILY}' prefix='{PREFIX}'/> \n""".format(IP=ip, FAMILY=ip_fam,PREFIX=prefix)
                            #if dhcp_filters.get(ip_fam):
                            #    nwfilter += nw_filter_template.format(NAME=dhcp_filters[ip_fam]) + "\n"
                            if static_data.get('default'):
                                address = "0.0.0.0"
                                if ip_fam == "ipv6":
                                    address = "::"
                                route += """<route family='{IP_FAM}' address='{ADDRESS}' prefix='0' gateway='{GATEWAY}'/> \n""".format(IP_FAM=ip_fam, ADDRESS=address, GATEWAY=gateway)

                    #static_intf = static_intf + 1
                if static_ipv4 and static_ipv6 :
                    if dhcp_filters.get("ipv4_ipv6"):
                        nwfilter += nw_filter_template.format(NAME=dhcp_filters["ipv4_ipv6"]) + "\n"
                elif static_ipv4:
                    if dhcp_filters.get("ipv4"):
                        nwfilter += nw_filter_template.format(NAME=dhcp_filters["ipv4"]) + "\n"
                elif static_ipv6:
                    if dhcp_filters.get("ipv6"):
                        nwfilter += nw_filter_template.format(NAME=dhcp_filters["ipv6"]) + "\n"


                interface = interface.format(SOURCE_NETWORK=libvirt_network,
                                             INTERFACE_NAME=interface_name,
                                             MAC_ENTRY=mac_entry,
                                             STATIC_IP=static_ip,
                                             ROUTE=route,
                                             FILTER=nwfilter)
            # making net admin cap off, as all interfaces are assigned with static data
            #if static_intf == len(source_network_list):
            #    net_admin = "<net_admin state='off'/>"
        else:
            interface = None

        if device_list:
            hm = HostingManager.get_instance()
            dm = hm.get_service("device-management")
            device_xml=""

            for device in device_list:
                dev_type = device.get("type")
                dev = dm.get_device(dev_type, device.get("device-id"))
                if dev_type == 'usbdev' and device.get("function") != "storage":

                    #For USB-serial devices,in some cases "device_name": "/dev/bus/usb/001/003",
                    #these need not be passed to libvirt as dev,bus details are sent in USB_HOSTDEV_BY_ADDR_XML
                    if "/dev/bus/usb/" not in dev.device_name:
                        usb_hostdev_xml = '%s' % CHARDEV_XML
                        device_xml +=  usb_hostdev_xml.format(DEVICE_ID=dev.device_name)

                    busnum = dev.bus
                    devnum = dev.dev
                    hostdev_addr_xml = '%s' % USB_HOSTDEV_BY_ADDR_XML
                    device_xml += hostdev_addr_xml.format( BN=busnum, DN=devnum)

                elif dev_type == 'char' or dev_type == 'serial':
                    chardev_xml = '%s' % CHARDEV_XML
                    device_xml += chardev_xml.format(DEVICE_ID=device.get("device-id"))
                else:
                    device_xml += ""
        else:
            device_xml = None



        if filesystem:
            #Parse the filesystem and add it in the mount_list to generate libvirt XML
            fs_xml = ""
            for fs in filesystem:
                fstype =  fs.get('fstype',None)

                if fstype == 'ram':
                    accmode = fs.get('accessmode', None)
                    target = fs.get('target',None)
                    if not target.startswith("/"):
                        target = "/" + target
                    source = fs.get('source', None)

                    if not accmode:
                        accmode= "passthrough"  #default is passthrough
                    mem_usage = source.get('usage')* 1024   #usage is always in MB
                    src = '%s'% FS_SOURCE_USAGE_XML.format(USAGE=mem_usage,UNITS="KiB")
                    fs_xml += '%s' % FILESYSTEM_XML.format(FSTYPE =fstype,
                                                    ACCESSMODE=accmode,DRIVER ="",SOURCE=src,DST_DIR=target, PERM="")

                    mount_xml += fs_xml

                else:
                    break

        if ramfs:
            ramfs_xml = ""
            ramfs_size = ramfs.get("size", None)
            target_dir = Utils.getRamFSdir()
            if ramfs_size:
                size_in_kb = int(ramfs_size) * 1024
                src = '%s' % FS_SOURCE_USAGE_XML.format(USAGE=(size_in_kb), UNITS="KiB")
                ramfs_xml += '%s' % FILESYSTEM_XML.format(FSTYPE="ram",
                                                        ACCESSMODE="squash", DRIVER="", SOURCE=src,
                                                        DST_DIR=target_dir, PERM="")
            mount_xml +=ramfs_xml


        # If app yaml provides console character device, override console with that
        console = None
        if chardev_list:
            for cdev in chardev_list:
                console += "<{DEV} type='{TYPE}' />\n"

                console = console.format(DEV=cdev['dev'], TYPE=cdev['type'])

        feature_capabilities = None

        if features and sec_attr:

            feature_capabilities = FEATURE_CAPABILITIES_XML
            privnet = features.get("privnet", "")
            policy = features.get("cap_policy", "default")
            if privnet:
                privnet = "<privnet/>"
            capabilities = features.get("capabilities",{})

            caps = ""
            caps_xml = ""
            if capabilities:
                for key,value in capabilities.items():
                    if value["status"]:
                        val = "on"
                    else:
                        val = "off"
                    caps += "       <{KEY} state='{VALUE}'/>\n"
                    caps = caps.format(KEY=key, VALUE=val)

                caps_xml = CAPABILITIES_XML.format(POLICY=policy, CAPS_DETAILS=caps)

            feature_capabilities = feature_capabilities.format(PRIVNET=privnet, CAPABILITIES=caps_xml)

        elif sec_attr:
            feature_capabilities = DEFAULT_FEATURE_CAPABILITIES_XML.format(NET_ADMIN=net_admin)

        sec_attrib = cls.generate_sec_Attr(sec_attr)  #secattr is populated from args

        libvirt_xml =  LibvirtXMLGenerator.generate_libvirt_xml(domain_type,
                                              appid,
                                              memory,
                                              cpu,
                                              cgroup_parent,
                                              osxml,
                                              emulator,
                                              vcpu,
                                              rootfs=root_fs,
                                              mount_list=mount_xml,
                                              interface=interface,
                                              device_list=device_xml,
                                              sec_attr = sec_attrib,
                                              feature_capabilities = feature_capabilities,
                                              console=console
                                              )


        return libvirt_xml


    @classmethod
    def generate_sec_Attr(cls, secattr):

        """
        Security obj of type
        {
         "label": "c1",
         "uidstart":'0',
         "uidtarget":'5000',
         "uidcount":'16',
         "gidstart":'0',
         "gidtarget":'5000',
         "gidcount":'1'
        }
        """


        if secattr is None:
            return None

        # XML format switch for Linux Security Modules
        lsm_config = secattr.get("lsm", None)
        if lsm_config:
            lsm_label = lsm_config.get("label", "")
            lsm_model = lsm_config.get("model", "none")
            if lsm_model == "smack":
                sec_xml = SECLABEL_SMACK_XML.format(SEC_LABEL=lsm_label)
            elif lsm_model == "selinux":
                sec_xml = SECLABEL_SELINUX_XML.format(SEC_LABEL=lsm_label)
            else:
                sec_xml = ""

        # Populate user namespace values
        uns_config = secattr.get("userns", None)
        if uns_config:
            # Format XML depending on shared gid enablement
            if "gidhostshared" in uns_config:
                idmap_xml = """
                        <idmap>
                            <uid start='{UID_START}' target='{UID_TARGET}' count='{UID_COUNT}'/>
                            <gid start='{GID_START}' target='{GID_TARGET}' count='{GID_COUNT}'/>
                            <gid start='{GID_HOST_SHARED_START}' target='{GID_HOST_SHARED}' count='1'/>
                        </idmap>
                        """
                idmap_xml = idmap_xml.format(
                        UID_START=uns_config["uidstart"],
                        GID_COUNT=uns_config["gidcount"],
                        UID_TARGET = uns_config["uidtarget"],
                        UID_COUNT = uns_config["uidcount"],
                        GID_START = uns_config["gidstart"],
                        GID_TARGET = uns_config["gidtarget"],
                        GID_HOST_SHARED=uns_config["gidhostshared"],
                        GID_HOST_SHARED_START=uns_config["gidcount"]
                )
            else:
                idmap_xml = """
                        <idmap>
                            <uid start='{UID_START}' target='{UID_TARGET}' count='{UID_COUNT}'/>
                            <gid start='{GID_START}' target='{GID_TARGET}' count='{GID_COUNT}'/>
                        </idmap>
                        """
                idmap_xml = idmap_xml.format(
                        UID_START=uns_config["uidstart"],
                        GID_COUNT=uns_config["gidcount"],
                        UID_TARGET=uns_config["uidtarget"],
                        UID_COUNT=uns_config["uidcount"],
                        GID_START=uns_config["gidstart"],
                        GID_TARGET=uns_config["gidtarget"]
                )

        securityLabelIdmap = ""
        try:
            if lsm_config and lsm_config.get("enabled", False):
                securityLabelIdmap = sec_xml
            if uns_config and uns_config.get("enabled", False):
                securityLabelIdmap += idmap_xml
        except KeyError:
            securityLabelIdmap = sec_xml + idmap_xml

        return securityLabelIdmap
