#-----------------------------------------------------
#
# Copyright (c) 2012 by cisco Systems, Inc.
# All rights reserved.
#-----------------------------------------------------

'''
Created on Sep 27, 2012

@author: rnethi
'''
import os
import shutil
import logging
import ConfigParser
from   stagingplugin import StagingPlugin
from   ..utils.utils import Utils

log = logging.getLogger("runtime.hosting")

class LuaStagingPlugin(StagingPlugin):
    '''
    Base class for standalone python runtime specific processing
    '''
    def __init__(self, baseDir, connectorArchiveFile, stagingReq, config=None):
        super(self.__class__, self).__init__(baseDir, connectorArchiveFile, stagingReq, config)
        self.metadata = self.stagingReq.getMetadata()
        self.useLauncher = self.metadata.use_launcher
        self.toolkit_required = self.metadata.toolkit
        self.env = {}
        
    def startStaging(self):
        '''
        Do work and return stagingResponse 
        '''
        self.createConnectorDirectories()
        self.extractArchiveFileToDestination()
        self.createStartScript()
        self.createStopScript()
        self.createCustomScripts()
        self.setupCustomLogFiles()
        
    def getStartScript(self):
        '''
        Return the startup script.
        Plugin implementations can use the helper methods generateStartScript() and 
        further customize 
        '''

        #If connector nofile limit has been specified, put that as part of start script
        cfg = self._getSystemConfig()
        customCommands = []
        if cfg.has_option("connector", "connectorOpenFilesLimit"):
            nofileLimit = cfg.getint("connector", "connectorOpenFilesLimit")
            customCommands.append("ulimit -n %d" % nofileLimit) 

        return self.generateStartScript(self.env, customCommands)

    def getPluginEnvironment(self):
        return self.env

    def getStopScript(self):
        '''
        Return the stop script
        Plugin implementations can use the helper methods generateStopScript() and
        further customize 
        '''
        return self.generateStopScript(env=self.env)
    
    def getCommandForStart(self):
        """
        Returns the system command to start the connector
        Language plugin implementations must override this
        """
        if self.customStartScript:
            return "$CAF_APP_PATH/"+self.customStartScript

        runnerFile = self.stagingReq.getMetadata().app_binary
        
        cmd = []
        cmd.append("lua")
        cmd.append("$CAF_APP_PATH/"+runnerFile)
        return " ".join(cmd)


    def _getSystemConfig(self):
        systemConfigPath = Utils.getSystemConfigPath()
        systemConfig = ConfigParser.SafeConfigParser()
        systemConfig.read(systemConfigPath)
        return systemConfig

