import os
import shutil
import logging
from appfw.utils.infraexceptions import *
from appfw.utils.filegen import filegen

log = logging.getLogger("runtime.hosting")
class FileMgmt(object):
    '''
    File Management  methods
    '''

    @classmethod
    def add_data_file(self, data_file, dstfilepath, disp_path):
        """
        Add the data_file at the specified destination
        """
        try:
            log.debug("Complete filename to upload: %s" % dstfilepath)
            delete_dst = True
            if os.path.exists(dstfilepath):
                delete_dst = False
                log.error("File/Path already exists: %s" % dstfilepath)
                raise ValueError("File/Path already exists cannot override: %s" % disp_path)

            #datafilepath = os.path.join(cshared, os.path.dirname(data_file_name).lstrip("/"))
            parent_non_path = dstfilepath 
            datafilepath = os.path.dirname(dstfilepath)
            if not os.path.exists(datafilepath):
                dstdir = datafilepath
                while not os.path.exists(dstdir):
                    parent_non_path = dstdir
                    dstdir = os.path.dirname(dstdir)  
                log.info("Path: %s not exists creating dirs" % os.path.dirname(datafilepath))
                os.makedirs(datafilepath)
            log.debug("Paths created from: %s" % parent_non_path)

            log.debug("Directory to upload:%s " % datafilepath)

            if os.path.isfile(data_file):
                shutil.move(data_file, dstfilepath)
                log.info("%s: data file uploaded!" % dstfilepath)
            else:
                log.error("No data file found at : %s", data_file)
                raise FilePathError("No data file found at : %s", data_file)
            return parent_non_path
        except Exception:
            if delete_dst and os.path.isfile(dstfilepath):
                os.remove(dstfilepath)
            raise

    @classmethod
    def get_data_file(self, dstfilepath, disp_path):
        """
        Reads the contents of data_file_name
        if it is directory:
            Returns dictionary with key as dirlist and Value is the list of file dict 
            e.g data["dirlist] = [ 
                name: "a.txt", type: "file", path: "appdata/a.txt", size: 100, last_modified_time: 1-Jan-15),
                name: "dir1/", type: "dir", path: "appdata/dir1", size: 0, last_modified_time: 2-Feb-15
            ]
        if data_file_name is regular file:
            Returns the generator function that reads data  contents of data_file_name 
        """
        if os.path.isdir(dstfilepath):
            data = {}
            dirlist = []
            for item in os.listdir(dstfilepath):
                file_dict = {}
                size = 0
                filename = os.path.join(dstfilepath, item)
                url_path=os.path.join(disp_path,  filename)
                f_stat = os.stat(filename)
                if os.path.isfile(filename):
                    if not os.path.islink(filename):
                        size = os.path.getsize(filename)
                        type = "file"
                    else:
                        continue
                else:
                    type = "dir"
                file_dict["name"] = item
                file_dict["path"] = url_path
                file_dict["type"] = type
                file_dict["size"] = size
                file_dict["last_modified_time"] = f_stat.st_atime
                dirlist.append(file_dict)
            data["dirlist"] = dirlist
            return data

        elif os.path.isfile(dstfilepath):
            if not os.path.islink(dstfilepath):
                log.info("%s: data file will be downloaded!" % dstfilepath)
                fg = filegen(dstfilepath)
                return fg
            else:
                return ""
        else:
            log.error("No data file found at : %s", disp_path)
            raise FilePathError("No data file found at : %s", disp_path)

    @classmethod
    def delete_data_file(self, dstfilepath, disp_path):
        """
        Delete the data_file_name from app appdata directory
        """
        if os.path.exists(dstfilepath):
            log.info("Deleting: %s" % dstfilepath)
            if os.path.isdir(dstfilepath):
                shutil.rmtree(dstfilepath)
            else:
                os.remove(dstfilepath)
        else:
            log.error("%s: does not exists" % disp_path)
            raise FilePathError("%s: does not exists" % disp_path)
    
