__author__ = 'madawood'
import json
import falcon
from common import make_response, make_error_response
from apiservice import ResourceRoute, APIService, get_client_address
from appfw.utils.utils import Utils
import shutil
import os
import logging
from common import AuthenticatedResource, make_response
from jsonencoder import JSONEncoder

log = logging.getLogger("runtime.api.resources")

jsonencoder = JSONEncoder(ensure_ascii=False)

#Available only to local clients
@ResourceRoute("/platform/hasync", endpoint="hasync")
class HasyncResource(AuthenticatedResource):

    def on_post(self, request, response):
        try:
            client_addr = get_client_address(request.env)
            if client_addr not in ('127.0.0.1', 'localhost'):
                make_error_response(response, "hasync service is unavailable", "hasync service is unavailable", falcon.HTTP_503)
                return

            hm = APIService.instance.hosting_manager
            hasync_service = hm.get_service("hasync-service")
            if hasync_service:
                hasync_service.queue_bulk_sync()
            log.info("Client Bulk HA Sync is initiated successfully")
        except Exception as ex:
            log.exception("Error while calling hasync on hosting manager.: %s" % str(ex))
            response = make_error_response(response,
                                           "Error scheduling hasync : %s" % str(ex),
                                           "Error scheduling hasync",
                                           falcon.HTTP_500)
            return

        response = make_response(response, "Hasync started", falcon.HTTP_200)
        return

    def on_get(self, request, response):
        try:
            hm = APIService.instance.hosting_manager
            hasync_service = hm.get_service("hasync-service")
            ha_enabled="no"
            if hasync_service:
                if hasync_service.is_enabled:
                    ha_enabled="yes"
                else:
                    ha_enabled="no"
            out = jsonencoder.encode({"ha_enabled": ha_enabled})
            response.status = falcon.HTTP_200
            response.body = out
            response.set_headers({'Content-Type': "application/json",
                                  'Cache-Control': "no-cache"})
            return response
        except Exception as ex:
            response = make_error_response(response,
                                           "Error getting hasync service state : %s" % str(ex),
                                           "Error getting hasync service state",
                                           falcon.HTTP_500)
            return
