import os
import io
import sys
import mimetypes

class filegen(object):
    """
    Generator for file contents which can be used by request stream
    """

    def __init__(self, fpath):
      self._fpath = fpath

    def __iter__(self):
        return self

    # Python 3 compatibility
    def __next__(self):
        return self.next()

    def next(self):
        with io.open(self._fpath, 'br') as f:
            chunk = f.read()
            yield chunk
      #with open(self.fpath, 'rb') as f: 
      #    while True: 
      #        piece = f.read(4096) 
      #        if piece: 
      #            yield piece 
      #        else: 
      #            raise StopIteration()

    @property
    def fpath(self):
        return self._fpath

    def __call__(self):
      return self.next()

'''
if "__main__" == __name__:
  fg = filegen("/tmp/asd-flask-tutorial.pdf")
  print fg
  print fg.fpath
  print mimetypes.guess_type(fg.fpath)
  f = file("/tmp/test.pdf","w")
  for c in fg():
    f.write(c)
  f.close()
'''