'''
Copyright (c) 2014 by Cisco Systems, Inc.
All rights reserved.

@author: havishwa
'''

import logging
import shutil
import tempfile
import tarfile
import os
import subprocess
import zipfile
import json
from stager import StagingResponse
from ..utils.utils import Utils, USER_EXTRACTED_DIR
from ..utils.docker_utils import DockerUtils, DOCKER_MANIFEST_FILE_NAME
import tarfile
from ..utils.infraexceptions import StagingError

log = logging.getLogger("runtime.hosting")

class DockerStager(object):
    """
    Stager for docker type application container
    """
    __singleton = None
    
    def __new__(cls, *args, **kwargs):
        # subclasses will create their own __singleton objects
        if cls != type(cls.__singleton):
            cls.__singleton = super(DockerStager, cls).__new__(cls, *args, **kwargs)
        return cls.__singleton

    @classmethod
    def getInstance(cls, *args):
        '''
        Returns a singleton instance of the class
        '''
        if not cls.__singleton:
            cls.__singleton = DockerStager(*args)
        return cls.__singleton

    def __init__(self, config, languageRuntimes=None):
        self._config = config
        self._staging_location = self._config.get("docker-container", "docker_staging_directory")
        if not os.path.isdir(self._staging_location):
            os.makedirs(self._staging_location)

    def stageConnector(self, stagingReq):
        """
        The docker rootfs tarball in extract_archive is extracted into rootfs in the repo directory.
        Then the layer tarballs are extracted into layercontents in each layer directory to form blobs of data.
        """

        log.debug("Begining staging for docker app. AppID: %s" % stagingReq.getConnectorId())
        staging_location = os.path.join(self._staging_location, stagingReq.getConnectorId())
        if not os.path.isdir(staging_location):
            os.makedirs(staging_location)
        pkg = stagingReq.getPackageObject()
        repodir = self._config.get("controller", "repo")
        pkg.dest_dir = os.path.join(repodir, stagingReq.getConnectorId(), USER_EXTRACTED_DIR)
        app_config_file_name = Utils.find_app_config_filename(pkg.dest_dir)
        if app_config_file_name:
            app_config_file_name = os.path.join(pkg.dest_dir, app_config_file_name)
        response = dict()
        response["staged-package-path"] = pkg.dest_dir
        response["app-config-file-name"] = app_config_file_name
        return StagingResponse(stagingReq.getConnectorId(), stagingReq.getPackagePath(), staging_location, response)

        
    def finish(self, connector, metadata, metadataFile, connectorArchiveFile, stagingResp):
        """
        Finish staging after connector deploys
        """
        log.debug("Staging complete.")
