__author__ = 'madawood'

import jsl


class AppInfo(jsl.Document):
    author_link = jsl.StringField(name="author-link", required=False)
    author_name = jsl.StringField(name="author-name", required=False)
    description = jsl.StringField(name="description", required=False)
    name = jsl.StringField(name="name", required=True)
    version = jsl.StringField(name="version", required=True)


class ResourcesRecommendations(jsl.Document):
    profile = jsl.StringField(name="profile", required=True)
    label = jsl.StringField(name="label", required=True)
    description = jsl.StringField(name="description", required=True)


class RuntimeOptions(jsl.Document):
    class Options(object):
        additional_properties = True

    classpath = jsl.StringField(name="classpath", required=True)


class Devices(jsl.Document):
    device_id = jsl.StringField(name="device-id", required=False)
    type = jsl.StringField(name="type", required=True)
    label = jsl.StringField(name="label", required=True)
    usage = jsl.StringField(name="usage", required=False)


class Network(jsl.Document):
    network_interface_name = jsl.StringField(name="interface-name", required=True)
    ports = jsl.AnyOfField([jsl.DictField({"tcp": jsl.ArrayField([jsl.IntField()], required=True)}, required=True),
                            jsl.DictField({"udp": jsl.ArrayField([jsl.IntField()], required=True)}, required=True)],
                           required=False)


class Resources(jsl.Document):
    profile = jsl.StringField(name="profile",
                              required=True)
    cpu = jsl.OneOfField([jsl.StringField(), jsl.IntField()], name="cpu", required=False)
    disk = jsl.OneOfField([jsl.StringField(), jsl.IntField()], name="disk", required=False)
    memory = jsl.OneOfField([jsl.StringField(), jsl.IntField()], name="memory", required=False)
    recommendation = jsl.ArrayField(jsl.DocumentField(ResourcesRecommendations, as_ref=True, required=True),
                                    name="recommendations", required=False)
    devices = jsl.ArrayField(jsl.DocumentField(Devices, as_ref=True, required=False), name="devices", required=False)
    network = jsl.ArrayField(jsl.DocumentField(Network, as_ref=True, required=True), name="network", required=False)


class Stop(jsl.Document):
    target = jsl.StringField(name="target", pattern="^[a-zA-Z]([^/]+(/)?)+$", required=True)


class StartupPaas(jsl.Document):
    runtime = jsl.NotField(jsl.StringField(name="runtime", enum=["generic-linux"]))
    target = jsl.StringField(name="target", pattern="^[a-zA-Z]([^/]+(/)?)+$", required=True)


class StartupGenericLinux(StartupPaas):
    runtime = jsl.StringField(name="runtime", enum=["generic-linux"], required=True)


class StartupNotGenericLinux(StartupPaas):
    runtime_options = jsl.DocumentField(RuntimeOptions, name="runtime-options", as_ref=True, required=False)
    runtime_version = jsl.OneOfField([jsl.NumberField(), jsl.StringField()], name="runtime-version", required=True)


class StartupLXC(jsl.Document):
    rootfs = jsl.StringField(name="rootfs", required=True)
    target = jsl.StringField(name="target", pattern="^[/a-zA-Z]([^/]+(/)?)+$", required=True)


class StartupVM(jsl.Document):
    rootfs = jsl.StringField(name="rootfs", required=True)
    kernel = jsl.StringField(name="kernel", required=True)


class CartridgeDependsOn(jsl.Document):
    id = jsl.StringField(name="id", required=True)
    version = jsl.NumberField(name="version", required=True)


class ServiceDependsOn(jsl.Document):
    id = jsl.StringField(name="id", required=True)
    min_api_version = jsl.NumberField(name="min-api-version", required=False)
    max_api_version = jsl.NumberField(name="max-api-version", required=False)
    required = jsl.BooleanField(name="required", required=False)


class Service(jsl.Document):
    id = jsl.StringField(name="id", required=True)
    api_version = jsl.NumberField(name="api-version", required=True)
    version = jsl.StringField(name="version", required=True)
    description = jsl.StringField(name="description", required=False)


class ServicesProvides(jsl.Document):
    provide = jsl.ArrayField(jsl.DocumentField(Service, as_ref=True, required=True), name="provides", required=True)


class AppV2(jsl.Document):
    cpuarch = jsl.StringField(name="cpuarch", required=False)
    resources = jsl.DocumentField(Resources, as_ref=True, required=False)
    depends_on = jsl.AnyOfField([jsl.DictField({"cartridges": jsl.ArrayField(
            jsl.DocumentField(CartridgeDependsOn, as_ref=True, required=True), required=True)}, required=True),
        jsl.DictField({"services": jsl.ArrayField(
                jsl.DocumentField(ServiceDependsOn, as_ref=True, required=True), required=True)},
                required=True)],
            required=False, name="depends-on")
    env = jsl.DictField({}, additional_properties=True, name='env')


class AppPaas(AppV2):
    type = jsl.StringField(name="type", enum=['paas'], required=True)
    startup = jsl.OneOfField([jsl.DocumentField(StartupGenericLinux, as_ref=True, required=True),
                              jsl.DocumentField(StartupNotGenericLinux, as_ref=True, required=True)], required=True)
    stop = jsl.DocumentField(Stop, as_ref=True, required=False)


class AppLXC(AppV2):
    cpuarch = jsl.StringField(name="cpuarch", required=True)
    type = jsl.StringField(name="type", enum=['lxc'], required=True)

    kernel_version = jsl.StringField(name="kernel-version", required=True)
    startup = jsl.DocumentField(StartupLXC, as_ref=True, required=True)
    depends_on = jsl.OneOfField([jsl.DictField(
            {"services": jsl.ArrayField(jsl.DocumentField(ServiceDependsOn, as_ref=True, required=True),
                                        required=True)},
            required=True)], required=False, name="depends-on")


class AppVM(AppV2):
    cpuarch = jsl.StringField(name="cpuarch", required=True)
    type = jsl.StringField(name="type", enum=['vm'], required=True)
    startup = jsl.DocumentField(StartupVM, as_ref=True, required=True)
    depends_on = jsl.OneOfField([jsl.DictField(
            {"services": jsl.ArrayField(jsl.DocumentField(ServiceDependsOn, as_ref=True, required=True),
                                        required=True)},
            required=True)], required=False, name="depends-on")


class PackageDescriptorV2(jsl.Document):
    """
    IOX package schema version 2.0 .
    """

    class Options(object):
        description = 'Schema for IOx application descriptor - version 2.0'

    descriptor_schema_version = jsl.OneOfField([jsl.StringField(), jsl.NumberField()], name="descriptor-schema-version",
                                               required=True)
    info = jsl.DocumentField(AppInfo, name="info", as_ref=True, required=True)
    app = jsl.OneOfField([jsl.DocumentField(AppPaas, as_ref=True, required=True),
                          jsl.DocumentField(AppLXC, as_ref=True, required=True),
                          jsl.DocumentField(AppVM, as_ref=True, required=True)], required=True)
    service_bundle = jsl.DocumentField(ServicesProvides, name="service-bundle", as_ref=True, required=False)
