#-----------------------------------------------------
#
# Copyright (c) 2012-2013 by Cisco Systems, Inc.
# All rights reserved.
#-----------------------------------------------------

'''
Created on Dec 06, 2012

@author: samagraw
'''

import logging
import os
from apiservice import APIService
from ..utils.utils import Utils
from ..hosting.apptypes import AppType

log = logging.getLogger("runtime.hosting")

class ConnectorConfig(object):

    @classmethod
    def getConnectorConfiguration(cls, connectorId):
        """ 
        Get config from app_config.ini
        """
        configFileContent = APIService.instance.app_manager.get_app_config(connectorId)

        connectorConfig = {"config": configFileContent,
                           "log-level": ""}

        return connectorConfig


    @classmethod
    def updateConnectorConfiguration(cls, connectorId, connectorConfig, logLevel=None):
        """
        Update app_config.ini and restart the connector
        """
        APIService.instance.app_manager.set_app_config(connectorId, connectorConfig)
        return

