'''
Created on Apr 02, 2015

@author: utandon

Copyright (c) 2015-2016 by Cisco Systems, Inc.
All rights reserved.
'''

import zipfile
import tarfile
from zippackage import ZipPackage
from tarpackage import TarPackage
from ..utils.infraexceptions import PackageInvalidError
import os

class PackageManager(object):
    """
    Package Manager to handle the different archive types.
    """
    support_package_types = ["zip", "tar", "ova"]
    
    @classmethod
    def getPackage(cls, archivePath, dest_dir,
                   check_integrity=False,
                   check_signature=False,
                   check_mandatory_files=False,
                   check_descriptor_schema=False,
                   check_app_compatibility=True,
                   check_descriptor_semantics=True,
                   conId=None):
        """
        From the archivePath returns the specific package class
        """
        if dest_dir is None:
            raise Exception("Destination Directory to extract not given")
        if archivePath is None or not os.path.isfile(archivePath):
            return TarPackage(archivePath, dest_dir, conIni=conId, check_integrity=check_integrity,
                              check_signature=check_signature, check_mandatory_files=check_mandatory_files,
                              check_descriptor_schema=check_descriptor_schema,
                              check_app_compatibility=check_app_compatibility,
                              check_descriptor_semantics=check_descriptor_semantics)
        elif tarfile.is_tarfile(archivePath):
            return TarPackage(archivePath, dest_dir, conIni=conId, check_integrity=check_integrity,
                              check_signature=check_signature, check_mandatory_files=check_mandatory_files,
                              check_descriptor_schema=check_descriptor_schema,
                              check_app_compatibility=check_app_compatibility,
                              check_descriptor_semantics=check_descriptor_semantics)
        else:
            raise Exception("Unknown application format.")

