__author__ = 'madawood'

import jsl


class AppInfo(jsl.Document):
    author_link = jsl.StringField(name="author-link", required=False)
    author_name = jsl.StringField(name="author-name", required=False)
    description = jsl.StringField(name="description", required=False)
    name = jsl.StringField(name="name", required=True)
    version = jsl.StringField(name="version", required=True)

class ResourcesRecommendations(jsl.Document):
    profile = jsl.StringField(name="profile", required=True)
    label = jsl.StringField(name="label", required=True)
    description = jsl.StringField(name="description", required=True)
    
class CharDev(jsl.Document):
    dev = jsl.StringField(name="dev", required=True)
    type = jsl.StringField(name="type", required=True)    

class Devices(jsl.Document):
    device_id = jsl.StringField(name="device-id", required=False)
    type = jsl.StringField(name="type", required=True)
    label = jsl.StringField(name="label", required=True)
    usage = jsl.StringField(name="usage", required=False)
    function = jsl.StringField(name="function", required=False)
    mandatory = jsl.BooleanField(name="mandatory", required=False)
    vendorID = jsl.StringField(name="vendorID", required=False)
    productID = jsl.StringField(name="productID", required=False)
    mount_point = jsl.StringField(name="mount-point", required=False)
    dev_dir_to_mount = jsl.StringField(name="device-directory-to-mount", required=False)

class Ports(jsl.Document):
    port = jsl.StringField(name="port", required=True)
    description = jsl.StringField(name="description", required=False)


class Network(jsl.Document):
    network_interface_name = jsl.StringField(name="interface-name", required=True)
    network_intf_description = jsl.StringField(name="description", required=False)
    ports = jsl.AnyOfField(
        [
            jsl.DictField(
                {
                    "tcp": jsl.ArrayField(
                        [
                            jsl.AnyOfField(
                                [
                                    jsl.StringField(),
                                    jsl.IntField(),
                                    jsl.DocumentField(Ports, as_ref=True)
                                ]
                            )
                        ]
                    )
                },
                required=True
            ),
            jsl.DictField(
                {
                    "udp": jsl.ArrayField(
                        [
                            jsl.AnyOfField(
                                [
                                    jsl.StringField(),
                                    jsl.IntField(),
                                    jsl.DocumentField(Ports, as_ref=True)
                                ]
                            )
                        ]
                    )
                },
                required=False
            )
        ]
    )
    ipv6_required = jsl.BooleanField(name="ipv6_required", required=False)


class Graphics(jsl.Document):
    vnc = jsl.BooleanField(name="vnc", required=False)

class CpuTopologyParams(jsl.Document):
    sockets_per_core = jsl.OneOfField([jsl.StringField(), jsl.IntField()], name="sockets-per-core", required=True)
    cores = jsl.OneOfField([jsl.StringField(), jsl.IntField()], name="cores", required=True)

class Resources(jsl.Document):
    profile = jsl.StringField(name="profile",
                              required=True)
    cpu = jsl.OneOfField([jsl.StringField(), jsl.IntField()], name="cpu", required=False)
    disk = jsl.OneOfField([jsl.StringField(), jsl.IntField()], name="disk", required=False)
    rootfs_size = jsl.OneOfField([jsl.StringField(), jsl.IntField()], name="rootfs_size", required=False)
    rootfs_expanded_size = jsl.OneOfField([jsl.StringField(), jsl.IntField()], name="rootfs_expanded_size", required=False)
    memory = jsl.OneOfField([jsl.StringField(), jsl.IntField()], name="memory", required=False)
    recommendation = jsl.ArrayField(jsl.DocumentField(ResourcesRecommendations, as_ref=True, required=True),
                                    name="recommendations", required=False)
    devices = jsl.ArrayField(jsl.DocumentField(Devices, as_ref=True, required=False), name="devices", required=False)
    device_info = jsl.ArrayField(jsl.StringField(enum=["udi"]), name="device-info", required=False)
    platform_env = jsl.ArrayField(jsl.StringField(), name="platform-env", required=False)
    oauth_info = jsl.ArrayField(jsl.StringField(enum=["OauthClient", "OauthValidator"]), name="oauth", required=False)
    broker = jsl.ArrayField(jsl.StringField(enum=["BrokerClient", "Broker"]), name="broker", required=False)
    network = jsl.ArrayField(jsl.DocumentField(Network, as_ref=True, required=True), name="network", required=False)
    graphics = jsl.DocumentField(Graphics, as_ref=True, required=False)
    vcpu = jsl.OneOfField([jsl.StringField(), jsl.IntField()], name="vcpu", required=False)
    chardev = jsl.ArrayField(jsl.DocumentField(CharDev, as_ref=True, required=True),
                                    name="chardev", required=False)
    cpu_topology = jsl.OneOfField([jsl.DocumentField(CpuTopologyParams, as_ref=True, required=True)], required=False, name="cpu-topology")
    visualization = jsl.BooleanField(name="visualization", required=False)
    datasore = jsl.BooleanField(name="datastore", required=False)


class Stop(jsl.Document):
    target = jsl.StringField(name="target", pattern="^[a-zA-Z]([^/]+(/)?)+$", required=True)


class StartupPaas(jsl.Document):

    # runtime = jsl.StringField(name="runtime", pattern="^((?!generic-linux).)*$", required=True)
    runtime = jsl.NotField(jsl.StringField(name="runtime", enum=["generic-linux"]))

    # runtime = jsl.NotField(jsl.StringField(name="runtime", enum=["generic-linux"], required=True),required=True)
    target = jsl.StringField(name="target", pattern="^[a-zA-Z]([^/]+(/)?)+$", required=True)


class StartupGenericLinux(StartupPaas):
    runtime = jsl.StringField(name="runtime", enum=["generic-linux"], required=True)


class RuntimeOptions(jsl.Document):
    class Options(object):
        additional_properties = True

    classpath = jsl.StringField(name="classpath", required=True)


class StartupNotGenericLinux(StartupPaas):
    runtime_options = jsl.DocumentField(RuntimeOptions, name="runtime-options", as_ref=True, required=False)
    runtime_version = jsl.OneOfField([jsl.NumberField(), jsl.StringField()], name="runtime-version", required=True)


class StartupLXC(jsl.Document):
    rootfs = jsl.StringField(name="rootfs", required=True)
    target = jsl.StringField(name="target", pattern="^[/a-zA-Z]([^/]+(/)?)+$", required=True)


class StartupVM(jsl.Document):
    rootfs = jsl.StringField(name="rootfs", required=True)
    kernel = jsl.StringField(name="kernel", required=True)


class StartupVM_2_1_DISKS(jsl.Document):
    ostype = jsl.StringField(name="ostype", required=False)
    qemu_guest_agent = jsl.BooleanField(name="qemu-guest-agent", required=False)
    disks = jsl.ArrayField(jsl.DictField({"target-dev": jsl.StringField(), "file": jsl.StringField()}, required=True),
                           required=True)


class StartupVM_2_1_RFS(StartupVM):
    ostype = jsl.StringField(name="ostype", required=False)
    qemu_guest_agent = jsl.BooleanField(name="qemu-guest-agent", required=False)


class StartupDocker(jsl.Document):
    rootfs = jsl.StringField(name="rootfs", required=True)
    target = jsl.OneOfField([jsl.StringField(name="target", pattern="^[/a-zA-Z]([^/]+(/)?)+$", required=True),
                              jsl.ArrayField(jsl.StringField(), required=True)], required=True)
    os_mode = jsl.BooleanField(name="os-mode", required=False)


class StartupDocker_2(jsl.Document):
    image_name = jsl.StringField(name="image-name", required=True)
    tag = jsl.StringField(name="tag", required=True)
    target = jsl.OneOfField([jsl.StringField(name="target", pattern="^[/a-zA-Z]([^/]+(/)?)+$", required=True),
                              jsl.ArrayField(jsl.StringField(), required=True)], required=True)


class CartridgeDependsOn(jsl.Document):
    id = jsl.StringField(name="id", required=True)
    version = jsl.NumberField(name="version", required=True)


class ServiceDependsOn(jsl.Document):
    id = jsl.StringField(name="id", required=True)
    min_api_version = jsl.NumberField(name="min-api-version", required=False)
    max_api_version = jsl.NumberField(name="max-api-version", required=False)
    required = jsl.BooleanField(name="required", required=False)
    label = jsl.StringField(name="label", required=False)

class PackageDependsOn(jsl.Document):
    name = jsl.StringField(name="name", required=True)
    version = jsl.StringField(name="version", required=True)
    #services = jsl.DictField({"services": jsl.ArrayField(jsl.DocumentField(ServiceDependsOn, as_ref=True, required=False), required=False)}, required=False)
    services = jsl.ArrayField(jsl.DocumentField(ServiceDependsOn, as_ref=True, required=False), required=False, name="services")

class AppV2(jsl.Document):
    cpuarch = jsl.StringField(name="cpuarch", required=False)
    resources = jsl.DocumentField(Resources, as_ref=True, required=False)
    depends_on = jsl.AnyOfField([jsl.DictField({"cartridges": jsl.ArrayField(
            jsl.DocumentField(CartridgeDependsOn, as_ref=True, required=True), required=True)}, required=True),
        jsl.DictField({"packages": jsl.ArrayField(
                jsl.DocumentField(PackageDependsOn, as_ref=True, required=True), required=True)},
                required=True)],
            required=False, name="depends-on")
    env = jsl.DictField({}, additional_properties=True, name='env')


class AppPaas(AppV2):
    type = jsl.StringField(name="type", enum=['paas'], required=True)
    startup = jsl.OneOfField([jsl.DocumentField(StartupGenericLinux, as_ref=True, required=True),
                              jsl.DocumentField(StartupNotGenericLinux, as_ref=True, required=True)], required=True)
    stop = jsl.DocumentField(Stop, as_ref=True, required=False)


class AppLXC(AppV2):
    cpuarch = jsl.StringField(name="cpuarch", required=True)
    cpufamily = jsl.StringField(name="cpu-core", required=False)
    type = jsl.StringField(name="type", enum=['lxc'], required=True)

    kernel_version = jsl.StringField(name="kernel-version", required=True)
    startup = jsl.DocumentField(StartupLXC, as_ref=True, required=True)
    depends_on = jsl.OneOfField([jsl.DictField(
            {"packages": jsl.ArrayField(jsl.DocumentField(PackageDependsOn, as_ref=True, required=True),
                                        required=True)},
            required=True)], required=False, name="depends-on")


class AppVM(AppV2):
    cpuarch = jsl.StringField(name="cpuarch", required=True)
    cpufamily = jsl.StringField(name="cpu-core", required=False)
    type = jsl.StringField(name="type", enum=['vm'], required=True)
    startup = jsl.OneOfField([jsl.DocumentField(StartupVM_2_1_RFS, as_ref=True, required=True),
                              jsl.DocumentField(StartupVM_2_1_DISKS, as_ref=True, required=True)], required=True)
    depends_on = jsl.OneOfField([jsl.DictField(
            {"packages": jsl.ArrayField(jsl.DocumentField(PackageDependsOn, as_ref=True, required=True),
                                        required=True)},
            required=True)], required=False, name="depends-on")


class AppDocker_2_2(AppV2):
    cpuarch = jsl.StringField(name="cpuarch", required=True)
    cpufamily = jsl.StringField(name="cpu-core", required=False)
    type = jsl.StringField(name="type", enum=['docker'], required=True)
    startup = jsl.OneOfField([jsl.DocumentField(StartupDocker, as_ref=True, required=True),
                              jsl.DocumentField(StartupDocker_2, as_ref=True, required=True)], required=True)
    depends_on = jsl.OneOfField([jsl.DictField(
            {"packages": jsl.ArrayField(jsl.DocumentField(PackageDependsOn, as_ref=True, required=True),
                                        required=True)},
            required=True)], required=False, name="depends-on")


class Service(jsl.Document):
    id = jsl.StringField(name="id", required=True)
    api_version = jsl.NumberField(name="api-version", required=True)
    version = jsl.StringField(name="version", required=True)
    description = jsl.StringField(name="description", required=False)
    port_mapping = jsl.ArrayField(jsl.StringField(pattern="^[\w]+:(tcp|udp){1}:[0-9-]+$"), name="port-mapping")


class ServicesProvides(jsl.Document):
    provide = jsl.ArrayField(jsl.DocumentField(Service, as_ref=True, required=True), name="provides", required=True)


class PackageDescriptorV2_5(jsl.Document):
    """
    IOX package schema version 2.5 .
    """

    class Options(object):
        description = 'Schema for IOx application descriptor - version 2.5'
    descriptor_schema_version = jsl.OneOfField([jsl.StringField(), jsl.NumberField()], name="descriptor-schema-version",
                                               required=True)
    info = jsl.DocumentField(AppInfo, name="info", as_ref=True, required=True)
    app = jsl.OneOfField([jsl.DocumentField(AppPaas, as_ref=True, required=True),
                          jsl.DocumentField(AppLXC, as_ref=True, required=True),
                          jsl.DocumentField(AppVM, as_ref=True, required=True),
                          jsl.DocumentField(AppDocker_2_2, as_ref=True, required=True)], required=True)
    service_bundle = jsl.DocumentField(ServicesProvides, name="service-bundle", as_ref=True, required=False)

