#!/bin/bash
#
# PD script to set CAF bridge properties
# It will be called after CAF creates each internal bridge
#
# Copyright (c) 2020 by Cisco Systems, Inc.
#


handle_post_nw_bridge() {
    # br_name: L2br, dpbr300, dpbr_v10, etc.
    # br_type: hosting_br, vlan, bridge, nat, nat_docker
    # netns: network namespace the bridge is in. None if it is in the same netns as CAF

    if [ "$netns" != "None" ] && [ "$netns" != "0" ]; then
        # If in another netns do nothing
        # mgmtbr, gs_nat
        exit 0
    fi

    if [ "$br_type" == "vlan" ]; then
        # L2br.10
        exit 0
    fi

    echo "Disabling mac leaks for $br_name, type: $br_type, netns: $netns"

    echo 8 > /proc/sys/net/ipv4/conf/$br_name/arp_ignore
    echo 1 > /proc/sys/net/ipv6/conf/$br_name/disable_ipv6

    # Experimental, comment out for now.
    # echo 1 > /proc/sys/net/ipv4/conf/$br_name/rp_filter
    # echo 1 > /proc/sys/net/ipv4/conf/$br_name/arp_filter
    # echo 0 > /proc/sys/net/ipv4/conf/$br_name/accept_redirects
    # echo 0 > /proc/sys/net/ipv4/conf/$br_name/forwarding
    # echo 0 > /proc/sys/net/ipv4/conf/$br_name/send_redirects
    # echo 0 > /proc/sys/net/ipv4/conf/$br_name/shared_media
    # echo 1 > /proc/sys/net/ipv4/conf/$br_name/drop_gratuitous_arp

    exit 0
}

case "$1" in
    post_create)
        br_name=$2
        br_type=$3
        netns=$4
        handle_post_nw_bridge
        ;;
    *)
        # Do nothing
        exit 0
        ;;
esac

exit 0