#!/bin/bash
#
# Copyright (c) 2017 by cisco Systems, Inc.
# All rights reserved.
#
# This script is added as part of app signature verification effort
# for IOX apps running on Polaris Platforms.
#
# On Polaris Platforms, IOX apps contain 'package.sign' signature file
# which will lead to running Polaris version of this script.
# This script on Polaris internally calls 'code_sign_verify' binary
# which will verify 'package.sign' signature file during app installation.
#
# On non-Polaris platforms, IOX apps contain 'package.cert' signature file
# which will not lead to this script.
# If an IOX app containing 'package.sign' gets installed on non-Polaris
# platforms, this script will successfully exit with return code 0,
# implying that the signature verification was successful.

# the arguments to code_sign_verify is 1.package model 2.signed file and the 3.signature file
#in that order. For Ex: code_sign_verify VmanPackage  package.mf package.sign

function err ()
{
    logger -p local0.error -t $(basename $0) "$@"
}

function info ()
{
    logger -p local0.info -t $(basename $0) "$@"
}

verifyappsignature(){

    $sign_cmd $1 $2 $3 &> /dev/null
    EXITVALUE=$?
    if [ $EXITVALUE == 0 ]; then
        info " App verification successful"
        exit $EXITVALUE
    else
        if [ $EXITVALUE == 241 ]; then
            err "Exit code 241: App signature verification failed due to bad signature and manifest artifacts combination"
        fi
        if [ $EXITVALUE == 203 ]; then
            err "Exit code 203: App signature file (package.sign) is corrupted."
        fi
        err "App signature verification failed with non-zero exit code"
        exit 1
    fi
}

sign_cmd=`which code_sign_verify`

if [ -z "$sign_cmd" ]
then
    err "signature verification command not found"
    exit -1
else
    verifyappsignature $1 $2 $3
fi