import logging
import os
import time
import falcon
import threading
from datetime import datetime
log = logging.getLogger("runtime.api")

NO_OF_REQS_PER_SEC = 3
COUNT = "count"
TIMESTAMP = "timestamp"

class RateLimiterMiddleware(object):

    def __init__(self):
        self.history = {}
    def process_request(self, req, resp, **kwargs):
        if req.path.endswith(("ioxv/datapoints", "ioxv/metadata", "iox/api/v2/hosting/datastore")):
            thread_id = threading.currentThread().name
            metadata = {}
            if self.history.has_key(thread_id):
                metadata = self.history[thread_id]
            else:
                metadata[TIMESTAMP] = int(time.time())
                metadata[COUNT] = 1
                self.history[thread_id] = metadata
                return

            if metadata[TIMESTAMP] == int(time.time()):
                if metadata[COUNT] < NO_OF_REQS_PER_SEC:
                    metadata[COUNT] = metadata[COUNT] + 1
                else:
                    log.debug("Dropping req for path %s metadata %s" %(req.path, metadata))
                    raise falcon.HTTPTooManyRequests('Too many requests',
                                                        '%s per sec'%NO_OF_REQS_PER_SEC)
            else:
                #reset the counters
                metadata[TIMESTAMP] = int(time.time())
                metadata[COUNT] = 1
