import zipfile
import os
import shutil
import logging
import sys
import ConfigParser
import zipfile
import subprocess
import shlex
import tempfile
import io

from ..hosting.state import State
from ..utils.utils import ImmutableMap, Utils, YAML_MANIFEST_NAME, INI_MANIFEST_NAME, APP_DESCRIPTOR_NAME, CARTRIDGE_MANIFEST_NAME
from ..hosting.apptypes import AppType
#from ..runtime.db import ConnectorMetadata
from ..runtime.descriptormetadata import descriptor_metadata_wrapper

from package import PackageInterface

log = logging.getLogger("runtime.hosting")


class ZipPackage(PackageInterface):
    """
    ZipPackage archive 
    """
    
    def __init__(self, archiveFile, dest_dir, conIni=None, appmanifest_file=None,
                appmanifest=None, metadatafile=None, appconfig_file=None,
                configschema_file=None,check_integrity=False, check_signature=False,
                check_mandatory_files=False, check_descriptor_schema=False,
                check_app_compatibility=True):

        self.tempfiles = []
        if appconfig_file is None:
            #appconfig_file = Utils.get_app_config_filename()
            pass
        if configschema_file is None:
            configschema_file = Utils.get_app_config_schema_filename()
        PackageInterface.__init__(self, archiveFile, dest_dir,
                                  conIni=conIni,
                                  appmanifest_file=appmanifest_file,
                                  appmanifest=appmanifest,
                                  metadatafile=metadatafile,
                                  appconfig_file=appconfig_file,
                                  configschema_file=configschema_file,
                                  check_integrity=check_integrity,
                                  check_signature=check_signature,
                                  check_mandatory_files=check_mandatory_files,
                                  check_descriptor_schema=check_descriptor_schema,
                                  check_app_compatibility=check_app_compatibility)

        extract = True 
        if self.dest_dir:
            if (os.path.exists(os.path.join(self.dest_dir, APP_DESCRIPTOR_NAME)) or
                os.path.exists(os.path.join(self.dest_dir, CARTRIDGE_MANIFEST_NAME)) or
                os.path.exists(os.path.join(self.dest_dir, YAML_MANIFEST_NAME)) or
                os.path.exists(os.path.join(self.dest_dir, INI_MANIFEST_NAME,)) ) :
                extract=False  

        if extract:
            self.extractall_to_destination(self.dest_dir)
            self.validate_package()
            self.extract_inner_envelope(self.dest_dir)

    def validate_package(self):
        """
        Validates the package
        """
        dest_dir = self.dest_dir
        try:
            #if self.check_mandatory_files or self.check_integrity or self.check_signature:
            #    self.extractall_to_destination(dest_dir)
            if self.check_mandatory_files:
                self.check_for_mandatory_files(dest_dir)
            if self.check_integrity:
                self.validate_package_integrity(dest_dir)
            if self.check_signature:
                self.validate_package_signature(dest_dir)
            if self.check_descriptor_schema:
                self.validate_descriptor_schema(dest_dir)
        finally:
            pass
            #shutil.rmtree(temp_dir)

    def get_metadatafile(self):
        """
        extracts the archive
        """
        if self.metadatafile is None:
            self._load_manifest()
        return self.metadatafile

    def extractall_to_destination(self, dest_path):
        # As part of - zip.extractall() directory traversal attack, we will not going to
        #    execute extractall() from this obsolete code
        # TODO Need to delete this code's entire flow
        return
        log.debug("Extracting archive:%s into the app directory:%s", self.tempArchivePath, dest_path)
        #cmd = "unzip -d "+dest_path+ " " + self.tempArchivePath
        cmd = ["unzip", "-d", dest_path, self.tempArchivePath]
        #If shell zip utility is not present on the system. Use the python zip module.
        error = False
        try:
            #subprocess.check_call(shlex.split(cmd))
            subprocess.check_call(cmd)
        except subprocess.CalledProcessError:
            log.exception("Error executing unzip command")
            error = True
        except OSError:
            error = True
            log.exception('Shell zip utility is not working on the system')
        except Exception:
            error = True
            log.exception("Generic exception using system's unzip")

        if error:
            log.debug("Using Python's zip module to extract..")
            with zipfile.ZipFile(self.tempArchivePath, 'r') as archiveZip:
                archiveZip.extractall(dest_path)


