#!/bin/ash
#
# Copyright (c) 2012-2014 by cisco Systems, Inc.
# All rights reserved.
#
# This script will be run manually and
# will collect all the logs and create a tar.

print_heading() {
    echo '' >> $dir/techsupport
    echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" >> $dir/techsupport
    echo $1 >> $dir/techsupport
    echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" >> $dir/techsupport
}

print_tail() {
    echo "" >> $dir/techsupport
}

print_file() {
    print_heading "$1"
    if [[ -f $2 ]]; then
        cat "$2" >> $dir/techsupport
    else
        echo "Missing" >> $dir/techsupport
    fi
    print_tail
}

print_exe() {
    print_heading "$1"
    $2 >> $dir/techsupport 2>/dev/null
    print_tail
}

#print_diag() {
#    local diag="/etc/scripts/diag-run "$2
#    print_heading "$1" $dir/diagnostics
#    ${diag} >> $dir/diagnostics
#    print_tail $dir/diagnostics
#}

#run_diagnostics() {
#    local f=${CONFIG_DIR}/diagnostic.yaml
#    if [ ! -f "${f}" ]; then
#        return 1
#    fi
#
#    enabled=$(grep "^enabled:" ${f} | cut -d':' -f2 | tr -d '[:space:]'; exit ${PIPESTATUS[0]})
#    if [ $? -ne 0 ]; then
#        return 2
#    fi
#
#    if [ "${enabled}" == "yes" ]; then
#        print_diag "Summary Diagnostic Output" "summary"
#        print_diag "Application Diagnostic Output" "application"
#        print_diag "Disk Diagnostic Output" "disk"
#        print_diag "Memory Diagnostic Output" "memory"
#        print_diag "Networking Diagnostic Output" "networking"
#        print_diag "Process Diagnostic Output" "process"
#    fi
#    return 0
#}

echo "Bundling and copying the logs"
date=`date -u +%Y-%m-%d_%H.%M.%S`
dir=tech_support_$date

mkdir $dir
mkdir $dir/logs
#mkdir $dir/cores
cp -r /var/log/caf.log* $dir/logs/
#cp -r /tmp/cores $dir/cores

#print_exe "Base system version" "/bin/version"

print_file "CAF version" "/home/root/iox/caf/config/version"

print_file "Hostname" "/proc/sys/kernel/hostname"

print_file "Hardware ID" "/etc/platform/hwid"

print_file "Product ID" "/etc/platform/product_id"

print_exe "System time" "date"

print_exe "IOX Summary" "systemctl status iox_*"

print_file "CAF System configuration system-config.ini" /home/root/iox/caf/config/system-config.ini

print_file "CAF Logging default-log-config.ini" /home/root/iox/caf/config/default-log-config.ini

print_file "CAF Logging log-config.ini" /home/root/iox/caf/config/log-config.ini

print_exe "List of Processes on host" "ps -aef"

print_exe "top command output" "top -n 1 -b"

print_exe "List of Interfaces" "ifconfig -a"

print_exe "Routing table" "route -n"

print_file "DNS information" "/etc/resolv.conf"

print_exe "Netstat information" "netstat -nlp"

print_exe "Disk Usage" "df -h"

print_exe "mount command output" "mount"

print_file "CPU information" "/proc/cpuinfo"

print_file "Memory information" "/proc/meminfo"

print_exe "free command output" "free"

print_exe "Active VM list" "virsh list --all"

# Run diag scripts, if present on the platform.
# run_diagnostics

for app in `ls /storage/software/caf/work/repo-lxc/lxc-data`; do
    mkdir -p $dir/logs/applications/$app

    cp -r /storage/software/caf/work/repo-lxc/lxc-data/$app/logs/* $dir/logs/applications/$app/
    print_exe  "Application $app - files" "ls -l /storage/software/caf/work/repo/$app/"
    print_exe  "Application $app - logs list" "ls -l /storage/software/caf/work/repo-lxc/lxc-data/$app/logs"
    print_file "Application $app - package.yaml" "/storage/software/caf/work/repo/$app/package.yaml"
    print_file "Application $app - db.ini" "/storage/software/caf/work/repo/$app/db.ini"
    print_file "Application $app - package_config.ini" "/storage/software/caf/work/repo/$app/extract_archive/package_config.ini"
    print_file "Application $app - app_manifest.yaml" "/storage/software/caf/work/repo/$app/app_manifest.yaml"
    print_file "Application $app - app_config.ini" "/storage/software/caf/work/repo/$app/app_config.ini"
done

tar czf $dir.tar.gz $dir
rm -rf $dir
echo "Please scp $dir.tar.gz to your system"
