# How to run tests

1) To run CAF UT test cases first need setup the CAF virtual environment, in order to do so need to run the ./setup-venv.sh script.

2) Once you done with virtual environment setup, now you can run the ./run-tests.sh --help command to view the various options provided by the test suite.
Example:
user@ubuntu:~/projects/iox-dev/core/caf/scripts$ ./run-tests.sh --help
specifying the options to run the test suite
Usage: ./run-tests.sh --lxc/--process/--docker/--all
--lxc: lxc container
--docker: docker container
--process: process container
--all: All container types
--ip: ip address of the machine where you want to run the test suite[127.0.0.1]
--port: port on which CAF is running[8443]
--user: username of the machine[jenkins]
--pass: password of the machine[jenkins]
--testdir: Only tests present in this directory will be executed
--testfile: Only tests present in this file will be executed
--testcase: Only this testcase will be executed. Must pass --testdir argument for location of the test file
--debug: to run the test suite in debugging mode
--exitfirst: exit the test suite at first failure
--artifacts: Location of custom artifacts in file/http/ftp URI format. Make sure to have all the artifacts listed in the class ArtifactHelper. If not specified, default artifacts located at http://173.39.49.216:9000/iox/test_resources/ will be used.
Upload artifacts & md5sum to 173.39.49.216:/nobackup/havishwa/lighthttpd/www/iox/test_resources/
Note: Options "--lxc/--process/--docker/--all" are only applicable if your running the test suite counter to local host

3) To trigger the test suite, run the script ./run-tests.sh <options>.
Example:
user@ubuntu:~/projects/iox-dev/core/caf/scripts$ sudo  ./run-tests.sh --all

4) If you want to run the test suite against a remote end point all you need to do is pass the ip, port, user and password as options to ./run-tests.sh script.
Example:
user@ubuntu:~/projects/iox-dev/core/caf/scripts$ ./run-tests.sh --ip 10.10.10.10 --port 8443 --user root --pass root --debug --exitfirst

5) Once successful test suite run is done means your basic sanity test of CAF is completed.

# Things can be needed for debugging
Approach 1:
- To run tests in a directory
Example:
scripts$ sudo ./run-tests --testdir ../tests/utils

- To run tests in a file
Example:
scripts$ sudo ./run-tests --testfile ../tests/utils/test_utilfuncs.py

- To run a specific testscase
Example:
scripts$ sudo ./run-tests --testdir ../tests/utils --testcase  test_kernel_version_compatibility

Approach 2:
-- In order to debug individual test case first you need to activate the virtual environment of CAF by using below command
    source ~/.virtualenvs/CAF/bin/activate

-- Let's assume that from above there are some test cases have failed, now you want that particular test case need to be executed in order to do so follow the below steps.
    - First go the directory of the file in which that test case is there.
    - Run the command:
        py.test -v -k <test_case_name>

-- If you want to run the whole file then,go to the file location and use this command.
    py.test -v <file name>
   To run the content of the whole directory then, go to that directory and use this command
    py.test -v .


