#-----------------------------------------------------
#
# Copyright (c) 2012-2013 by cisco Systems, Inc.
# All rights reserved.
#-----------------------------------------------------

__author__ = 'havishwa'
from appfw.runtime.caf_abstractservice import CAFAbstractService

class AppManagerInterface(CAFAbstractService):
    """
    App management apis
    """
    def __init__(self):
        pass

    def install_app(self, appid, archivefile, extracted_path, delete_archive = True, is_autoinstalled = False):
        """blocking version"""
        pass

    def install_app_async(self, appid, archivefile, extracted_path, delete_archive = True, is_autoinstalled = False):
        """non blocking version"""
        pass

    def activate_app_async(self, appid, resources):
        pass

    def activate_app(self, appid, resources):
        pass

    def deactivate_app_async(self, appid):
        pass

    def deactivate_app(self, appid):
        pass


    def uninstall_app(self, appid, preserveData=False):
        """blocking version"""
        pass

    def uninstall_app_async(self, appid):
        """non blocking version"""
        pass

    def reinstall_app(self, appid, archivefile):
        """blocking version"""
        pass

    def reinstall_app_async(self, appid, archivefile):
        """non blocking version"""
        pass

    def upgrade_app(self, appid, archivefile, preserveData, is_package_cleanup=True):
        """blocking version"""
        pass

    def upgrade_app_async(self, appid, archivefile, preserveData):
        """non blocking version"""
        pass

    def start_app(self, appid):
        """blocking version"""
        pass

    def start_app_async(self, appid):
        """non blocking version"""
        pass

    def stop_app(self, appid):
        """blocking version"""
        pass

    def stop_app_async(self, appid):
        """non blocking version"""
        pass

    def set_app_custom_options(self, connectorId, app_data):
        """
        Persist applications data in db.ini.
        To be called only when the application installation is successfully complete.
        """
        pass

    def exists(self, appid):
        pass

    def list(self):
        """List installed apps"""
        pass

    def list_services(self):
        """List services provided by service-bundle"""
        pass

    def get(self, appid):
        '''
        Returns an existing ConnectorWrapper for the given appid 
        only if the connector is deployed.
        but will not return if the connector was created but not deployed
        '''
        pass

    def get_app_status(self, appid):
        pass

    def get_logfile_list(self, appid):
        pass

    def delete_app_logfiles(self, appid, filename=None):
        pass

    def get_logfile_path(self, appid, logfilename):
        pass

    def get_logfile_lines(self, appid, logfilename, lines=10):
        pass

    def call_app_hook(self, appid, cmd, args=""):
        pass

    def get_app_package(self, appid):
        pass

    def get_process_info(self, appid):
        pass

    def get_logfile_contents(self, appid, filename):
        """
        Return the contents of the logfile
        """

    def subscribe(self, callback, event_type = None, event_nature=None):
        """
        Subscribe caller to an event type. The caller is expected to pass a callback.
        If event_type is None, subscribe caller to all available event types
        If successful, return True. Else return False.
        """
        pass

    def unsubscribe(self, callback):
        """
        Unsubscribe a callback from all events
        """
        pass

    def get_app_metrics(self):
        """ Fetch CPU utilization by the application, 
        amount of memory utilized by the application during execution, 
        amount of disk space needed and the network resource utilization. 
        """
        pass

    def get_caf_metrics(self):
        """ Fetch CAF metrics, 
        amount of memory utilized by the CAF, No of threads, etc
        Request metrics, total request served, time taken etc
        """
        pass

    def get_stats_types(self):
        """
        Returns the list of stats available
        """
        pass

    def get_stats_config(self) :
        """
        Returns the stats configuration
        """
        pass

    def set_stats_config(self, config) :
        """
        Sets the stats configuration
        """
        pass

    def get_platform_capability(self):
        """
        Return platform capabilities info describing total and currently available resources
        """
        pass

    def get_app_config(self, appid):
        """
        Return config file contents of the requested app
        """
        pass

    def set_app_config(self, appid, content):
        """
        Set the requested app's config file contents
        """
        pass

    def add_data_file(self, appid, data_file_name, content):
        """
        Add the requested app's data file 
        """
        pass

    def delete_data_file(self, appid, data_file_name, content):
        """
        Delete the app's data file 
        """
        pass

    def get_data_file(self, app_id, datafilepath):
        """
        Return the contents of the file at datafilepath for an app
        or list the directory contents at datafilepath
        """
        pass

    def autoinstall(self):
        """
        :return:
        """
        pass

    def get_autoinstall_data(self):
        """
        :return:
        """
        pass
