#!/bin/sh
# Will teardown the network for Given container

HELP(){
    echo 'This script teardown network for docker style applications'
    echo 'Will be executed at the time of app stop'
    echo 'Usage: ./docker_network_dhclient_teardown.sh -d $DOMID -p $PIDREPO -i $INTERFACE -r $RESOLV_CONF -s $SCRIPT_PATH'
    echo '-d: domain id of the conatiner'
    echo '-f: IP family for which you want to run the DHCP client'
    echo '-p: PID repo to store the DHCP client daemon pids'
    echo '-i: Interface to which ip needs to be assigned'
    echo '-r: DNS resolve file path. Should be the location w.r.t the apps rootfs'
    echo '-s: DHCP client - custom script path'
    echo '-c: Provide DHCP client identifier'
    echo 'Note: Before running this script, make sure you have network name space is up and running in host for the container'
    echo 'To create network namespace of the container, run this command: ln -s /proc/{CON_INIT_PID}/ns/net /var/run/netns/{DOM_ID}'
    exit 1
}
echo "Running the docker network up script"
# Making sure process is running with root user
if [ "$(id -u)" != "0" ]; then
        echo "This script must be run as root" 1>&2
        exit 1
fi
pointer=1
while [ $pointer -le $# ]; do
   #param=$1
   if [ "`expr \"$1\" : \"- .*\"`" = "0" ];then
      case $1 in
         -d | --domid)
                shift
                DOMAIN_ID=$1
                ;;
         -p | --pidrepo)
                shift
                PID_REPO=$1
                ;;
         -i | --interface)
                shift
                INTERFACE=$1
                ;;
         -r | --resolvconf)
                shift
                R_CONF=$1
                ;;
         -s | --script)
                shift
                SCRIPT_PATH=$1
                ;;
         -c | --clientid)
                shift
                CLIENT_ID=$1
                ;;
         -f | --ipfamily)
                shift
                IP_FAMILY=$1
                ;;
         -h|--help) HELP ;;
         *)
            echo "Invalid option: $1"
            exit 1 ;;
      esac
   else
      echo "Invalid parameters passed: check --help option"
      exit 1
   fi
   shift
done
if [ "x$DOMAIN_ID" = "x" ] || [ "x$PID_REPO" = "x" ] || [ "x$INTERFACE" = "x" ] || [ "x$R_CONF" = "x" ] || [ "x$IP_FAMILY" = "x" ];then
	echo "Mandatory Arguments: DomainId:$DOMAIN_ID, PidRepo:$PID_REPO ,Intf:$INTERFACE, ResolveConf:$R_CONF, IP family:$IP_FAMILY are missing"
	exit 1
fi

# Check for the dhclient binary is exists
if which dhclient >/dev/null; then
    echo "dhclient binary exists"
else
    echo "dhclient binary not found!"
    exit 1
fi

DHCLIENT_CONFIG_FILE="$PID_REPO/dhcp.conf"

# dhclient to run for ipv4 or ipv6
fam_param=-4
family=ipv4
if [ "x$IP_FAMILY" = "x" ];then
echo "No ipfamily parameter provided so, assuming defaults"
else
case $IP_FAMILY in
     ipv4)
            fam_param=-4
            family=ipv4
            ;;
     ipv6)
            fam_param=-6
            family=ipv6
            ;;
     *)
        echo "Invalid option for ip family: $IP_FAMILY"
        exit 1 ;;
esac
fi
LEASE=.lease
net_return=0
# Entering the container network space and running dhclient on a interface and trying to get ip for it.
if [ "x$family" != "xipv6" ];then
    if [ "x$SCRIPT_PATH" = "x" ];then
        ip netns exec $DOMAIN_ID dhclient -v -r $fam_param -r -e RESOLVCONF=$R_CONF -lf $PID_REPO/$INTERFACE$family$LEASE -cf $DHCLIENT_CONFIG_FILE $INTERFACE
        net_return=$?
    else
        ip netns exec $DOMAIN_ID dhclient -v -r $fam_param -r -e RESOLVCONF=$R_CONF -lf $PID_REPO/$INTERFACE$family$LEASE -sf $SCRIPT_PATH -cf $DHCLIENT_CONFIG_FILE $INTERFACE
        net_return=$?
    fi
fi
if [ $net_return != 0 ]; then
	echo "Issue while releasing IP with dhclient. So exiting. Return code: $net_return"
	exit 0
fi
exit 0
