#!/bin/sh

#This script creates the user, adds the user to the libvirt group
ROOT_UID=0
SUCCESS=0

add_user()
{
    # Check if user already exists.
    grep -c "^$username:" /etc/passwd
    if [ $? -eq $SUCCESS ]
    then
        echo "User does already exist."
        return 0
    else
        adduser -G "$group" "$username" -D -g "" -s /bin/ash
        if [ $? -eq $SUCCESS ]
        then
            echo "Added the user $username to group $group"
            return 0
        else
            echo "Unable to add the user $username to group $group"
            return 1
        fi
    fi
}

add_group()
{
    # Check if group already exists.
    grep -q -E "^"$group":" /etc/group
    if [ $? -eq $SUCCESS ]
    then
            echo "Group already exists! Skipping group creation..."
    else
            addgroup $group
            echo "Group added"
    fi
    return 0
}

docker_setup()
{
    # Check for virsh in console user's home, if not copy from system and lock down
    mkdir -p /home/$username/.bin
    cp -f $virsh_image /home/$username/.bin/virsh

    if [ $? -eq $SUCCESS ]
    then
        chown root:$group /home/$username/.bin/virsh && \
        chmod 550 /home/$username/.bin/virsh && \
        setcap "=ep" /home/$username/.bin/virsh
        if [ $? -eq $SUCCESS ]
        then
            echo "Virsh executable created for console."
            return 0
        else
            echo "Unable to create virsh executable for docker console support."
            return 1
        fi
        echo "There was an error while applying permissions on the binary."
        return 1
    fi
    return 0
}

# Run as root
if [ "$(id -u)" != "0" ]; then
   echo "This script must be run as root" 1>&2
   exit 1
fi

#test, if arguments are there
if [ $# -ge 2 ]; then
    username=$1
    group=$2
    docker_support=$3
    virsh_image=$4

    # Setup
    add_group
    add_user
    if [ $? -ne $SUCCESS ]
    then
        echo "Error while adding user."
        exit 1
    fi

    if [ "$docker_support" = "True" ] && [ ! -e /home/$username/.bin/virsh ]
    then
        docker_setup
        if [ $? -ne $SUCCESS ]
        then
            echo "Error while setting up Docker console components."
            exit 1
        fi
    fi

    echo "the account for accessing application console is setup"

else
    echo  " program needs at least 2 arguments you have given $# "
    echo  " you have to call the script $0 username and the group that the user has to be added "
    exit 1
fi

exit 0
